/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseTSTEos;
import neqsim.thermo.system.SystemEos;

public class SystemTSTEos
extends SystemEos {
    private static final long serialVersionUID = 1000L;
    double[][] TBPfractionCoefs = new double[][]{{73.404, 97.356, 0.61874, -2059.3, 0.0}, {0.072846, 2.1881, 163.91, -4043.4, 0.3333333333333333}, {0.37377, 0.005493, 0.011793, -4.9E-6, 0.0}};

    public SystemTSTEos() {
        this.modelName = "TST-EOS";
        this.attractiveTermNumber = 14;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseTSTEos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
        }
    }

    public SystemTSTEos(double T, double P) {
        super(T, P);
        this.modelName = "TST-EOS";
        this.attractiveTermNumber = 14;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseTSTEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
    }

    public SystemTSTEos(double T, double P, boolean solidCheck) {
        this(T, P);
        this.attractiveTermNumber = 14;
        this.setNumberOfPhases(5);
        this.modelName = "TST-EOS";
        this.solidPhaseCheck = solidCheck;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseTSTEos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemTSTEos clone() {
        SystemTSTEos clonedSystem = null;
        try {
            clonedSystem = (SystemTSTEos)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

