/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkCPA;
import neqsim.thermo.system.SystemSrkEos;

public class SystemSrkCPA
extends SystemSrkEos {
    private static final long serialVersionUID = 1000L;

    public SystemSrkCPA() {
        this.modelName = "CPA-SRK-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPA();
        }
        this.useVolumeCorrection(true);
        this.commonInitialization();
    }

    public SystemSrkCPA(double T, double P) {
        super(T, P);
        this.modelName = "CPA-SRK-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPA();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
        this.commonInitialization();
    }

    public SystemSrkCPA(double T, double P, boolean solidCheck) {
        super(T, P, solidCheck);
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseSrkCPA();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
        this.commonInitialization();
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemSrkCPA clone() {
        SystemSrkCPA clonedSystem = null;
        try {
            clonedSystem = (SystemSrkCPA)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }

    public void commonInitialization() {
        this.setImplementedCompositionDeriativesofFugacity(true);
        this.setImplementedPressureDeriativesofFugacity(true);
        this.setImplementedTemperatureDeriativesofFugacity(true);
    }

    @Override
    public void addComponent(String componentName, double moles) {
        super.addComponent(componentName, moles);
    }
}

