/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePrCPA;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemPrEos;

public class SystemPrCPA
extends SystemPrEos {
    private static final long serialVersionUID = 1000L;

    public SystemPrCPA() {
        this.modelName = "CPA-PR-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrCPA();
        }
        this.useVolumeCorrection(true);
    }

    public SystemPrCPA(double T, double P) {
        super(T, P);
        this.modelName = "CPA-PR-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrCPA();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
    }

    public SystemPrCPA(double T, double P, boolean solidCheck) {
        super(T, P, solidCheck);
        this.modelName = "CPA-PR-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhasePrCPA();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(true);
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemPrCPA clone() {
        SystemPrCPA clonedSystem = null;
        try {
            clonedSystem = (SystemPrCPA)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

