/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGERG2004Eos;
import neqsim.thermo.phase.PhaseHydrate;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.system.SystemEos;

public class SystemGERG2004Eos
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemGERG2004Eos() {
        this.modelName = "GERG2004-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGERG2004Eos();
            this.phaseArray[i].setTemperature(298.15);
            this.phaseArray[i].setPressure(1.0);
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    public SystemGERG2004Eos(double T, double P) {
        super(T, P);
        this.modelName = "GERG2004-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGERG2004Eos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    public SystemGERG2004Eos(double T, double P, boolean solidCheck) {
        this(T, P);
        this.modelName = "GERG2004-EOS";
        this.setNumberOfPhases(5);
        this.solidPhaseCheck = solidCheck;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGERG2004Eos();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        if (this.hydrateCheck) {
            this.phaseArray[this.numberOfPhases - 1] = new PhaseHydrate();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
        this.useVolumeCorrection(false);
        this.commonInitialization();
    }

    @Override
    public SystemGERG2004Eos clone() {
        SystemGERG2004Eos clonedSystem = null;
        try {
            clonedSystem = (SystemGERG2004Eos)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }

    public void commonInitialization() {
        this.setImplementedCompositionDeriativesofFugacity(false);
        this.setImplementedPressureDeriativesofFugacity(false);
        this.setImplementedTemperatureDeriativesofFugacity(false);
    }
}

