/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseElectrolyteCPA;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermo.util.constants.FurstElectrolyteConstants;

public class SystemElectrolyteCPA
extends SystemFurstElectrolyteEos {
    private static final long serialVersionUID = 1000L;

    public SystemElectrolyteCPA() {
        this.modelName = "Electrolyte-CPA-EOS";
        this.attractiveTermNumber = 0;
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseElectrolyteCPA();
        }
        FurstElectrolyteConstants.setFurstParams("electrolyteCPA");
        this.useVolumeCorrection(false);
    }

    public SystemElectrolyteCPA(double T, double P) {
        super(T, P);
        this.attractiveTermNumber = 0;
        this.modelName = "Electrolyte-CPA-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseElectrolyteCPA();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        FurstElectrolyteConstants.setFurstParams("electrolyteCPA");
        this.useVolumeCorrection(false);
    }

    @Override
    public SystemElectrolyteCPA clone() {
        SystemElectrolyteCPA clonedSystem = null;
        try {
            clonedSystem = (SystemElectrolyteCPA)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedSystem;
    }
}

