/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentPCSAFTa;
import neqsim.thermo.mixingRule.CPAMixing;
import neqsim.thermo.mixingRule.CPAMixingInterface;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhasePCSAFT;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhasePCSAFTa
extends PhasePCSAFT
implements PhaseCPAInterface {
    private static final long serialVersionUID = 1000L;
    public CPAMixing cpaSelect = new CPAMixing();
    public CPAMixingInterface cpamix;
    double hcpatot = 1.0;
    double hcpatotdT = 0.0;
    double hcpatotdTdT = 0.0;
    int cpaon = 1;
    int totalNumberOfAccociationSites = 0;
    double gcpav = 0.0;
    double lngcpa = 0.0;
    double gcpavv = 1.0;
    double gcpavvv = 0.0;
    double gcpa = 0.0;
    int[][][] selfAccociationScheme = null;
    int[][][][] crossAccociationScheme = null;
    static Logger logger = LogManager.getLogger(PhasePCSAFTa.class);

    @Override
    public PhasePCSAFTa clone() {
        PhasePCSAFTa clonedPhase = null;
        try {
            clonedPhase = (PhasePCSAFTa)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
        this.cpamix = this.cpaSelect.getMixingRule(3, this);
    }

    @Override
    public void volInit() {
        super.volInit();
        this.gcpa = this.getGhsSAFT();
        this.lngcpa = Math.log(this.getGhsSAFT());
        this.gcpav = 1.0 / this.getGhsSAFT() * this.getDgHSSAFTdN() * this.getDnSAFTdV();
        this.gcpavv = -1.0 / Math.pow(this.getGhsSAFT(), 2.0) * this.dgHSSAFTdN * this.dgHSSAFTdN * this.getDnSAFTdV() * this.getDnSAFTdV() + 1.0 / this.getGhsSAFT() * this.dgHSSAFTdNdN * this.getDnSAFTdV() * this.getDnSAFTdV() + 1.0 / this.getGhsSAFT() * this.getDgHSSAFTdN() * this.dnSAFTdVdV;
        this.gcpavvv = 0.0;
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        if (type == 0) {
            this.selfAccociationScheme = new int[numberOfComponents][0][0];
            this.crossAccociationScheme = new int[numberOfComponents][numberOfComponents][0][0];
            for (int i = 0; i < numberOfComponents; ++i) {
                this.selfAccociationScheme[i] = this.cpaSelect.setAssociationScheme(i, this);
                for (int j = 0; j < numberOfComponents; ++j) {
                    this.crossAccociationScheme[i][j] = this.cpaSelect.setCrossAssociationScheme(i, j, this);
                }
            }
        }
        do {
            super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        } while (!this.solveX());
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(componentName, moles, molesInPhase, compNumber);
        this.componentArray[compNumber] = new ComponentPCSAFTa(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public double getF() {
        return super.getF() + (double)this.cpaon * this.FCPA();
    }

    @Override
    public double dFdT() {
        return super.dFdT() + (double)this.cpaon * this.dFCPAdT();
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV();
    }

    @Override
    public double dFdV() {
        double dv2 = this.dFCPAdV();
        return super.dFdV() + (double)this.cpaon * dv2;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + (double)this.cpaon * this.dFCPAdVdV();
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + (double)this.cpaon * this.dFCPAdVdVdV();
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + (double)this.cpaon * this.dFCPAdTdT();
    }

    public double FCPA() {
        double tot = 0.0;
        double ans = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            tot = 0.0;
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                double xai = ((ComponentPCSAFTa)this.getComponent(i)).getXsite()[j];
                tot += Math.log(xai) - 0.5 * xai + 0.5;
            }
            ans += this.getComponent(i).getNumberOfMolesInPhase() * tot;
        }
        return ans;
    }

    public double dFCPAdV() {
        return 1.0 / (2.0 * this.getTotalVolume()) * (1.0 - this.getTotalVolume() * this.gcpav * 1.0E-5) * this.hcpatot;
    }

    public double dFCPAdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdV() + this.hcpatot / (2.0 * this.getTotalVolume()) * (-this.gcpav * 1.0E-5 - this.getTotalVolume() * this.gcpavv * 1.0E-10);
    }

    public double dFCPAdVdVdV() {
        return -1.0 / this.getTotalVolume() * this.dFCPAdVdV() + 1.0 / Math.pow(this.getTotalVolume(), 2.0) * this.dFCPAdV() - this.hcpatot / (2.0 * Math.pow(this.getTotalVolume(), 2.0)) * (-this.gcpav * 1.0E-5 - this.getTotalVolume() * this.gcpavv * 1.0E-10) + this.hcpatot / (2.0 * this.getTotalVolume()) * (-this.gcpavv * 1.0E-10 - this.getTotalVolume() * this.gcpavvv * 1.0E-10 - this.gcpavv * 1.0E-10);
    }

    public double dFCPAdT() {
        return -0.5 * this.hcpatotdT;
    }

    public double dFCPAdTdT() {
        return -0.5 * this.hcpatotdTdT;
    }

    public double calc_hCPA() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            htot = 0.0;
            for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                htot += 1.0 - ((ComponentPCSAFTa)this.getComponent(i)).getXsite()[j];
            }
            tot += this.getComponent(i).getNumberOfMolesInPhase() * htot;
        }
        return tot;
    }

    public double calc_hCPAdT() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int k = 0; k < this.numberOfComponents; ++k) {
                htot = 0.0;
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    for (int l = 0; l < this.getComponent(k).getNumberOfAssociationSites(); ++l) {
                        htot += ((ComponentPCSAFTa)this.getComponent(i)).getXsite()[j] * ((ComponentPCSAFTa)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                    }
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
            }
        }
        return tot / this.getTotalVolume();
    }

    public double calc_hCPAdTdT() {
        double htot = 0.0;
        double tot = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int k = 0; k < this.numberOfComponents; ++k) {
                htot = 0.0;
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    for (int l = 0; l < this.getComponent(k).getNumberOfAssociationSites(); ++l) {
                        htot += ((ComponentPCSAFTa)this.getComponent(i)).getXsite()[j] * ((ComponentPCSAFTa)this.getComponent(k)).getXsite()[l] * this.cpamix.calcDeltadTdT(j, l, i, k, this, this.temperature, this.pressure, this.numberOfComponents);
                    }
                }
                tot += this.getComponent(i).getNumberOfMolesInPhase() * this.getComponent(k).getNumberOfMolesInPhase() * htot;
            }
        }
        return tot / this.getTotalVolume();
    }

    public boolean solveX() {
        double err = 0.0;
        int iter = 0;
        do {
            ++iter;
            err = 0.0;
            for (int i = 0; i < this.numberOfComponents; ++i) {
                for (int j = 0; j < this.getComponent(i).getNumberOfAssociationSites(); ++j) {
                    double old = ((ComponentPCSAFTa)this.getComponent(i)).getXsite()[j];
                    double neeval = this.cpamix.calcXi(this.selfAccociationScheme, this.crossAccociationScheme, j, i, this, this.temperature, this.pressure, this.numberOfComponents);
                    ((ComponentCPAInterface)this.getComponent(i)).setXsite(j, neeval);
                    err += Math.abs((old - neeval) / neeval);
                }
            }
        } while (Math.abs(err) > 1.0E-10 && iter < 100);
        return Math.abs(err) < 1.0E-10;
    }

    @Override
    public double getHcpatot() {
        return this.hcpatot;
    }

    public void setHcpatot(double hcpatot) {
        this.hcpatot = hcpatot;
    }

    @Override
    public double getGcpa() {
        return this.gcpa;
    }

    public double calc_lngni(int comp) {
        return 0.0;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phase == 0 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
        if (BonV < 0.0) {
            BonV = 1.0E-6;
        }
        if (BonV > 1.0) {
            BonV = 0.999999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double d1 = 0.0;
        Btemp = this.getB();
        if (Btemp <= 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        int maxIterations = 1000;
        do {
            ++iterations;
            this.volInit();
            this.solveX();
            this.hcpatot = this.calc_hCPA();
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / Math.pow(BonV, 2.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            d1 = -h / dh;
            this.setMolarVolume(1.0 / (BonV += d1) * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < maxIterations);
        if (BonV < 0.0) {
            BonV = pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        }
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }

    @Override
    public double getGcpav() {
        return this.gcpav;
    }

    @Override
    public CPAMixingInterface getCpamix() {
        return this.cpamix;
    }

    @Override
    public int getCrossAssosiationScheme(int comp1, int comp2, int site1, int site2) {
        if (comp1 == comp2) {
            return this.selfAccociationScheme[comp1][site1][site2];
        }
        return this.crossAccociationScheme[comp1][comp2][site1][site2];
    }

    @Override
    public int getTotalNumberOfAccociationSites() {
        return this.totalNumberOfAccociationSites;
    }

    @Override
    public void setTotalNumberOfAccociationSites(int totalNumberOfAccociationSites) {
        this.totalNumberOfAccociationSites = totalNumberOfAccociationSites;
    }
}

