/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentModifiedFurstElectrolyteEos;
import neqsim.thermo.mixingRule.ElectrolyteMixingRulesInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhaseModifiedFurstElectrolyteEos
extends PhaseSrkEos {
    private static final long serialVersionUID = 1000L;
    double gammaold = 0.0;
    double alphaLRdTdV = 0.0;
    double W = 0.0;
    double WT = 0.0;
    double WTT = 0.0;
    double eps = 0.0;
    double epsdV = 0.0;
    double epsdVdV = 0.0;
    double epsIonic = 0.0;
    double bornX = 0.0;
    double epsIonicdV = 0.0;
    double epsIonicdVdV = 0.0;
    double alphaLR2 = 0.0;
    double alphaLRdT = 0.0;
    double alphaLRdTdT = 0.0;
    double alphaLRdV = 0.0;
    double XLR = 0.0;
    double solventDiElectricConstant = 0.0;
    double solventDiElectricConstantdT = 0.0;
    double solventDiElectricConstantdTdT = 0.0;
    double shieldingParameter = 0.0;
    double gamma = 0.0;
    double diElectricConstantdV = 0.0;
    double diElectricConstantdVdV = 0.0;
    double alphaLRdVdV = 0.0;
    double diElectricConstantdT = 0.0;
    double diElectricConstantdTdT = 0.0;
    double diElectricConstantdTdV = 0.0;
    ElectrolyteMixingRulesInterface electrolyteMixingRule = this.mixSelect.getElectrolyteMixingRule(this);
    double sr2On = 1.0;
    double lrOn = 1.0;
    double bornOn = 1.0;
    static Logger logger = LogManager.getLogger(PhaseModifiedFurstElectrolyteEos.class);

    public ElectrolyteMixingRulesInterface getElectrolyteMixingRule() {
        return this.electrolyteMixingRule;
    }

    public void reInitFurstParam() {
        for (int k = 0; k < this.numberOfComponents; ++k) {
            ((ComponentModifiedFurstElectrolyteEos)this.componentArray[k]).initFurstParam();
        }
        this.electrolyteMixingRule = this.mixSelect.getElectrolyteMixingRule(this);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
        if (type == 0) {
            this.electrolyteMixingRule = this.mixSelect.getElectrolyteMixingRule(this);
        }
    }

    @Override
    public PhaseModifiedFurstElectrolyteEos clone() {
        PhaseModifiedFurstElectrolyteEos clonedPhase = null;
        try {
            clonedPhase = (PhaseModifiedFurstElectrolyteEos)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    public void volInit() {
        this.W = this.electrolyteMixingRule.calcW(this, this.temperature, this.pressure, this.numberOfComponents);
        this.WT = this.electrolyteMixingRule.calcWT(this, this.temperature, this.pressure, this.numberOfComponents);
        this.WTT = this.electrolyteMixingRule.calcWTT(this, this.temperature, this.pressure, this.numberOfComponents);
        this.eps = this.calcEps();
        this.epsdV = this.calcEpsV();
        this.epsdVdV = this.calcEpsVV();
        this.epsIonic = this.calcEpsIonic();
        this.epsIonicdV = this.calcEpsIonicdV();
        this.epsIonicdVdV = this.calcEpsIonicdVdV();
        this.solventDiElectricConstant = this.calcSolventDiElectricConstant(this.temperature);
        this.solventDiElectricConstantdT = this.calcSolventDiElectricConstantdT(this.temperature);
        this.solventDiElectricConstantdTdT = this.calcSolventDiElectricConstantdTdT(this.temperature);
        this.diElectricConstant = this.calcDiElectricConstant(this.temperature);
        this.diElectricConstantdT = this.calcDiElectricConstantdT(this.temperature);
        this.diElectricConstantdTdT = this.calcDiElectricConstantdTdT(this.temperature);
        this.diElectricConstantdV = this.calcDiElectricConstantdV(this.temperature);
        this.diElectricConstantdVdV = this.calcDiElectricConstantdVdV(this.temperature);
        this.diElectricConstantdTdV = this.calcDiElectricConstantdTdV(this.temperature);
        this.alphaLR2 = 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * 8.3144621 * this.temperature);
        this.alphaLRdT = -1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * 8.3144621 * this.temperature * this.temperature) - 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdT;
        this.alphaLRdV = -1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdV;
        this.alphaLRdTdT = 3.0922301761789923E-14 / (8.85419E-12 * this.diElectricConstant * 8.3144621 * Math.pow(this.temperature, 3.0)) + 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature * this.temperature) * this.diElectricConstantdT - 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdTdT + 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature * this.temperature) * this.diElectricConstantdT + 3.0922301761789923E-14 / (8.85419E-12 * Math.pow(this.diElectricConstant, 3.0) * 8.3144621 * this.temperature) * Math.pow(this.diElectricConstantdT, 2.0);
        this.alphaLRdTdV = 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature * this.temperature) * this.diElectricConstantdV + 3.0922301761789923E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdT * this.diElectricConstantdV - 1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdTdV;
        this.alphaLRdVdV = -1.5461150880894962E-14 / (8.85419E-12 * this.diElectricConstant * this.diElectricConstant * 8.3144621 * this.temperature) * this.diElectricConstantdVdV + 3.0922301761789923E-14 / (8.85419E-12 * Math.pow(this.diElectricConstant, 3.0) * 8.3144621 * this.temperature) * this.diElectricConstantdV * this.diElectricConstantdV;
        this.shieldingParameter = this.calcShieldingParameter();
        this.XLR = this.calcXLR();
        this.bornX = this.calcBornX();
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentModifiedFurstElectrolyteEos(componentName, moles, molesInPhase, compNumber);
    }

    public double calcSolventDiElectricConstant(double temperature) {
        double ans1 = 0.0;
        double ans2 = 1.0E-50;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() != 0.0) continue;
            ans1 += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstant(temperature);
            ans2 += this.componentArray[i].getNumberOfMolesInPhase();
        }
        return ans1 / ans2;
    }

    public double calcSolventDiElectricConstantdT(double temperature) {
        double ans1 = 0.0;
        double ans2 = 1.0E-50;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() != 0.0) continue;
            ans1 += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdT(temperature);
            ans2 += this.componentArray[i].getNumberOfMolesInPhase();
        }
        return ans1 / ans2;
    }

    public double calcSolventDiElectricConstantdTdT(double temperature) {
        double ans1 = 0.0;
        double ans2 = 1.0E-50;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() != 0.0) continue;
            ans1 += this.componentArray[i].getNumberOfMolesInPhase() * this.componentArray[i].getDiElectricConstantdTdT(temperature);
            ans2 += this.componentArray[i].getNumberOfMolesInPhase();
        }
        return ans1 / ans2;
    }

    public double calcEps() {
        double eps = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            eps += 3.153635421825E23 * this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10, 3.0) * 1.0 / (this.numberOfMolesInPhase * this.getMolarVolume() * 1.0E-5);
        }
        return eps;
    }

    public double calcEpsV() {
        return -this.getEps() / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase);
    }

    public double calcEpsVV() {
        return 2.0 * this.getEps() / Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0);
    }

    public double calcEpsIonic() {
        double epsIonicLoc = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() == 0.0) continue;
            epsIonicLoc += 3.153635421825E23 * this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10, 3.0) / (this.numberOfMolesInPhase * this.getMolarVolume() * 1.0E-5);
        }
        return epsIonicLoc;
    }

    public double calcEpsIonicdV() {
        return -this.getEpsIonic() / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase);
    }

    public double calcEpsIonicdVdV() {
        return 2.0 * this.getEpsIonic() / Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0);
    }

    @Override
    public double getF() {
        return super.getF() + this.FSR2() * this.sr2On + this.FLR() * this.lrOn + this.FBorn() * this.bornOn;
    }

    @Override
    public double dFdT() {
        return super.dFdT() + this.dFSR2dT() * this.sr2On + this.dFLRdT() * this.lrOn + this.dFBorndT() * this.bornOn;
    }

    @Override
    public double dFdTdV() {
        return super.dFdTdV() + this.dFSR2dTdV() * this.sr2On + this.dFLRdTdV() * this.lrOn;
    }

    @Override
    public double dFdV() {
        return super.dFdV() + this.dFSR2dV() * this.sr2On + this.dFLRdV() * this.lrOn;
    }

    @Override
    public double dFdVdV() {
        return super.dFdVdV() + this.dFSR2dVdV() * this.sr2On + this.dFLRdVdV() * this.lrOn;
    }

    @Override
    public double dFdVdVdV() {
        return super.dFdVdVdV() + this.dFSR2dVdVdV() * this.sr2On + this.dFLRdVdVdV() * this.lrOn;
    }

    @Override
    public double dFdTdT() {
        return super.dFdTdT() + this.dFSR2dTdT() * this.sr2On + this.dFLRdTdT() * this.lrOn + this.dFBorndTdT() * this.bornOn;
    }

    public double calcXLR() {
        double ans = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (this.componentArray[i].getIonicCharge() == 0.0) continue;
            ans += this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getIonicCharge(), 2.0) * this.getShieldingParameter() / (1.0 + this.getShieldingParameter() * this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10);
        }
        return ans;
    }

    public double calcGammaLRdV() {
        if (this.phaseType == 1) {
            return 0.0;
        }
        return 1.0 / (8.0 * this.getShieldingParameter()) * (4.0 * Math.pow(this.getShieldingParameter(), 2.0) / this.getAlphaLR2() * this.alphaLRdV + 4.0 * Math.pow(this.getShieldingParameter(), 2.0) / (this.numberOfMolesInPhase * this.getMolarVolume() * 1.0E-5));
    }

    public double calcShieldingParameter() {
        double df = 0.0;
        double f = 0.0;
        int ions = 0;
        int iterations = 0;
        this.gamma = 1.0E10;
        do {
            ++iterations;
            this.gammaold = this.gamma;
            ions = 0;
            f = 4.0 * Math.pow(this.gamma, 2.0) / 6.023E23;
            df = 8.0 * this.gamma / 6.023E23;
            for (int i = 0; i < this.numberOfComponents; ++i) {
                if (this.componentArray[i].getIonicCharge() == 0.0) continue;
                ++ions;
                f += -this.getAlphaLR2() * this.componentArray[i].getNumberOfMolesInPhase() / (this.getMolarVolume() * this.numberOfMolesInPhase * 1.0E-5) * Math.pow(this.componentArray[i].getIonicCharge() / (1.0 + this.gamma * this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10), 2.0);
                df += 2.0 * this.getAlphaLR2() * this.componentArray[i].getNumberOfMolesInPhase() / (this.getMolarVolume() * this.numberOfMolesInPhase * 1.0E-5) * Math.pow(this.componentArray[i].getIonicCharge(), 2.0) * (this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10) / Math.pow(1.0 + this.gamma * this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10, 3.0);
            }
            double d = this.gamma = ions > 0 ? this.gammaold - 0.8 * f / df : 0.0;
        } while (Math.abs(f) > 1.0E-10 && iterations < 1000 || iterations < 3);
        return this.gamma;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double BonV;
        double d = BonV = phase == 0 ? 0.99 : 1.0E-5;
        if (BonV < 0.0) {
            BonV = 1.0E-6;
        }
        if (BonV > 1.0) {
            BonV = 0.999999;
        }
        double BonVold = BonV;
        double Btemp = 0.0;
        double h = 0.0;
        double dh = 0.0;
        double dhh = 0.0;
        double d1 = 0.0;
        double d2 = 0.0;
        Btemp = this.getB();
        if (Btemp <= 0.0) {
            logger.info("b negative in volume calc");
        }
        this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
        int iterations = 0;
        int maxIterations = 1000;
        do {
            ++iterations;
            this.volInit();
            BonVold = BonV;
            h = BonV - Btemp / this.numberOfMolesInPhase * this.dFdV() - pressure * Btemp / (this.numberOfMolesInPhase * 8.3144621 * temperature);
            dh = 1.0 + Btemp / Math.pow(BonV, 2.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV());
            dhh = -2.0 * Btemp / Math.pow(BonV, 3.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdV()) - Math.pow(Btemp, 2.0) / Math.pow(BonV, 4.0) * (Btemp / this.numberOfMolesInPhase * this.dFdVdVdV());
            d1 = -h / dh;
            d2 = -dh / dhh;
            if (Math.abs(d1 / d2) <= 1.0) {
                BonV += d1 * (1.0 + 0.5 * d1 / d2);
            } else if (d1 / d2 < -1.0) {
                BonV += d1 * 0.5;
            } else if (d1 / d2 > 1.0) {
                BonV += d2;
                double hnew = h + d2 * -h / d1;
                if (Math.abs(hnew) > Math.abs(h)) {
                    logger.info("volume correction needed....");
                    double d3 = BonV = phase == 1 ? 2.0 / (2.0 + temperature / this.getPseudoCriticalTemperature()) : pressure * this.getB() / (this.numberOfMolesInPhase * temperature * 8.3144621);
                }
            }
            if (BonV > 1.0) {
                BonV = 0.999999;
                BonVold = 10.0;
            }
            if (BonV < 0.0) {
                BonV = 1.0E-6;
                BonVold = 10.0;
            }
            this.setMolarVolume(1.0 / BonV * Btemp / this.numberOfMolesInPhase);
            this.Z = pressure * this.getMolarVolume() / (8.3144621 * temperature);
        } while (Math.abs((BonV - BonVold) / BonV) > 1.0E-10 && iterations < maxIterations);
        this.volInit();
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "molarVolume", (long)maxIterations);
        }
        if (Double.isNaN(this.getMolarVolume())) {
            throw new IsNaNException(this, "molarVolume", "Molar volume");
        }
        return this.getMolarVolume();
    }

    public double calcW(PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        this.W = this.electrolyteMixingRule.calcW(phase, temperature, pressure, numbcomp);
        return this.W;
    }

    public double calcWi(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.electrolyteMixingRule.calcWi(compNumb, phase, temperature, pressure, numbcomp);
    }

    public double calcWiT(int compNumb, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.electrolyteMixingRule.calcWiT(compNumb, phase, temperature, pressure, numbcomp);
    }

    public double calcWij(int compNumb, int compNumbj, PhaseInterface phase, double temperature, double pressure, int numbcomp) {
        return this.electrolyteMixingRule.calcWij(compNumb, compNumbj, phase, temperature, pressure, numbcomp);
    }

    @Override
    public double calcDiElectricConstant(double temperature) {
        return 1.0 + (this.getSolventDiElectricConstant() - 1.0) * (1.0 - this.getEpsIonic()) / (1.0 + this.getEpsIonic() / 2.0);
    }

    public double calcDiElectricConstantdV(double temperature) {
        double X = (1.0 - this.getEpsIonic()) / (1.0 + this.getEpsIonic() / 2.0);
        double Y = this.getSolventDiElectricConstant() - 1.0;
        double dXdf = this.getEpsIonicdV() * -3.0 / 2.0 / Math.pow(this.getEpsIonic() / 2.0 + 1.0, 2.0);
        double dYdf = 0.0;
        return dYdf * X + Y * dXdf;
    }

    public double calcDiElectricConstantdVdV(double temperature) {
        double Y = this.getSolventDiElectricConstant() - 1.0;
        double dXdf = this.getEpsIonicdVdV() * -3.0 / 2.0 / Math.pow(this.getEpsIonic() / 2.0 + 1.0, 2.0) + this.getEpsIonicdV() * this.getEpsIonicdV() * 3.0 / 2.0 / Math.pow(this.getEpsIonic() / 2.0 + 1.0, 3.0);
        return Y * dXdf;
    }

    @Override
    public double calcDiElectricConstantdT(double temperature) {
        double X = (1.0 - this.getEpsIonic()) / (1.0 + this.getEpsIonic() / 2.0);
        double Y = this.getSolventDiElectricConstant() - 1.0;
        double dXdf = 0.0;
        double dYdf = this.getSolventDiElectricConstantdT();
        return dYdf * X + Y * dXdf;
    }

    @Override
    public double calcDiElectricConstantdTdT(double temperature) {
        return this.getSolventDiElectricConstantdTdT() * (1.0 - this.epsIonic) / (1.0 + this.epsIonic / 2.0);
    }

    public double calcDiElectricConstantdTdV(double temperature) {
        double Y = this.getSolventDiElectricConstantdT();
        double dXdf = this.getEpsIonicdV() * -3.0 / 2.0 / Math.pow(this.getEpsIonic() / 2.0 + 1.0, 2.0);
        return Y * dXdf;
    }

    public double calcBornX() {
        double ans = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!(this.componentArray[i].getLennardJonesMolecularDiameter() > 0.0)) continue;
            ans += this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getIonicCharge(), 2.0) / (this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10);
        }
        return ans;
    }

    public double FLR() {
        double ans = 0.0;
        return (ans -= 0.07957747163687819 * this.getAlphaLR2() * this.getXLR()) + this.numberOfMolesInPhase * this.getMolarVolume() * 1.0E-5 * Math.pow(this.getShieldingParameter(), 3.0) / 5.676543759285001E24;
    }

    public double dFLRdT() {
        return this.dFdAlphaLR() * this.alphaLRdT;
    }

    public double dFLRdTdV() {
        return this.dFdAlphaLR() * this.alphaLRdTdV * 1.0E-5;
    }

    public double dFLRdTdT() {
        return this.dFdAlphaLR() * this.alphaLRdTdT;
    }

    public double dFLRdV() {
        return (this.FLRV() + this.dFdAlphaLR() * this.alphaLRdV) * 1.0E-5;
    }

    public double dFLRdVdV() {
        return this.dFdAlphaLR() * this.alphaLRdVdV * 1.0E-10;
    }

    public double dFLRdVdVdV() {
        return 0.0;
    }

    public double FLRXLR() {
        return -this.getAlphaLR2() / 12.5663706;
    }

    public double FLRGammaLR() {
        return 3.0 * this.numberOfMolesInPhase * this.getMolarVolume() * 1.0E-5 * Math.pow(this.getShieldingParameter(), 2.0) / 5.676543759285001E24;
    }

    public double dFdAlphaLR() {
        return -0.07957747163687819 * this.XLR;
    }

    public double dFdAlphaLRdV() {
        return 0.0;
    }

    public double dFdAlphaLRdX() {
        return -0.07957747163687819;
    }

    public double dFdAlphaLRdGamma() {
        return 0.0;
    }

    public double FLRV() {
        return Math.pow(this.getShieldingParameter(), 3.0) / 5.676543759285001E24;
    }

    public double FLRVV() {
        return 0.0;
    }

    public double dFdAlphaLRdAlphaLR() {
        return 0.0;
    }

    public double XLRdndn(int i, int j) {
        return 0.0;
    }

    public double XLRdGammaLR() {
        double ans = 0.0;
        double ans2 = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            ans -= this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10 * this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getIonicCharge(), 2.0) * this.getShieldingParameter() / Math.pow(1.0 + this.getShieldingParameter() * this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10, 2.0);
            ans2 += this.componentArray[i].getNumberOfMolesInPhase() * Math.pow(this.componentArray[i].getIonicCharge(), 2.0) / (1.0 + this.getShieldingParameter() * this.componentArray[i].getLennardJonesMolecularDiameter() * 1.0E-10);
        }
        return ans2 + ans;
    }

    public double XBorndndn(int i, int j) {
        return 0.0;
    }

    public double FSR2() {
        return this.getW() / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * (1.0 - this.eps));
    }

    public double dFSR2dT() {
        return this.FSR2W() * this.WT;
    }

    public double dFSR2dTdT() {
        return this.FSR2W() * this.WTT;
    }

    public double dFSR2dV() {
        return (this.FSR2V() + this.FSR2eps() * this.getEpsdV()) * 1.0E-5;
    }

    public double dFSR2dTdV() {
        return (this.FSR2VW() * this.WT + this.FSR2epsW() * this.epsdV * this.WT) * 1.0E-5;
    }

    public double dFSR2dVdV() {
        return (this.FSR2VV() + 2.0 * this.FSR2epsV() * this.getEpsdV() + this.FSR2epseps() * Math.pow(this.getEpsdV(), 2.0) + this.FSR2eps() * this.getEpsdVdV()) * 1.0E-10;
    }

    public double dFSR2dVdVdV() {
        return (this.FSR2VVV() + 3.0 * this.FSR2epsepsV() * Math.pow(this.getEpsdV(), 2.0) + 3.0 * this.FSR2VVeps() * this.getEpsdV() + this.FSR2epsepseps() * Math.pow(this.getEpsdV(), 3.0)) * 1.0E-15;
    }

    public double FSR2W() {
        return 1.0 / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * (1.0 - this.eps));
    }

    public double FSR2V() {
        return -this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0) * (1.0 - this.eps));
    }

    public double FSR2T() {
        return 0.0;
    }

    public double FSR2n() {
        return 0.0;
    }

    public double FSR2eps() {
        return this.W / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * Math.pow(1.0 - this.eps, 2.0));
    }

    public double FSR2nn() {
        return 0.0;
    }

    public double FSR2nT() {
        return 0.0;
    }

    public double FSR2nV() {
        return 0.0;
    }

    public double FSR2neps() {
        return 0.0;
    }

    public double FSR2nW() {
        return 0.0;
    }

    public double FSR2Tn() {
        return 0.0;
    }

    public double FSR2TT() {
        return 0.0;
    }

    public double FSR2TV() {
        return 0.0;
    }

    public double FSR2Teps() {
        return 0.0;
    }

    public double FSR2TW() {
        return 0.0;
    }

    public double FSR2VV() {
        return 2.0 * this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 3.0) * (1.0 - this.eps));
    }

    public double FSR2epsV() {
        return -this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0) * Math.pow(1.0 - this.eps, 2.0));
    }

    public double FSR2epsW() {
        return 1.0 / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * Math.pow(1.0 - this.eps, 2.0));
    }

    public double FSR2WW() {
        return 0.0;
    }

    public double FSR2VW() {
        return -1.0 / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0) * (1.0 - this.eps));
    }

    public double FSR2epseps() {
        return 2.0 * this.W / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * Math.pow(1.0 - this.eps, 3.0));
    }

    public double FSR2VVV() {
        return -6.0 * this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 4.0) * (1.0 - this.eps));
    }

    public double FSR2epsepsV() {
        return -2.0 * this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 2.0) * Math.pow(1.0 - this.eps, 3.0));
    }

    public double FSR2VVeps() {
        return 2.0 * this.W / (Math.pow(this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase, 3.0) * Math.pow(1.0 - this.eps, 2.0));
    }

    public double FSR2epsepseps() {
        return 6.0 * this.W / (this.getMolarVolume() * 1.0E-5 * this.numberOfMolesInPhase * Math.pow(1.0 - this.eps, 4.0));
    }

    public double FBorn() {
        return 1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature) * (1.0 / this.getSolventDiElectricConstant() - 1.0) * this.bornX;
    }

    public double dFBorndT() {
        return this.FBornT() + this.FBornD() * this.solventDiElectricConstantdT;
    }

    public double dFBorndTdT() {
        return this.FBornTT() + this.FBornTD() * this.solventDiElectricConstantdT;
    }

    public double FBornT() {
        return -(1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature * this.temperature)) * (1.0 / this.getSolventDiElectricConstant() - 1.0) * this.bornX;
    }

    public double FBornX() {
        return 1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature) * (1.0 / this.getSolventDiElectricConstant() - 1.0);
    }

    public double FBornD() {
        return -(1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature)) * 1.0 / Math.pow(this.getSolventDiElectricConstant(), 2.0) * this.bornX;
    }

    public double FBornTT() {
        return 2.0 * (1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature * this.temperature * this.temperature)) * (1.0 / this.getSolventDiElectricConstant() - 1.0) * this.bornX;
    }

    public double FBornTD() {
        return 1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature * this.temperature) * 1.0 / Math.pow(this.getSolventDiElectricConstant(), 2.0) * this.bornX;
    }

    public double FBornTX() {
        return -(1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature * this.temperature)) * (1.0 / this.getSolventDiElectricConstant() - 1.0);
    }

    public double FBornDD() {
        return 2.0 * (1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature)) * 1.0 / Math.pow(this.getSolventDiElectricConstant(), 3.0) * this.bornX;
    }

    public double FBornDX() {
        return -(1.5461150880894965E-14 / (9.251088991257001E-10 * this.temperature)) * 1.0 / Math.pow(this.getSolventDiElectricConstant(), 2.0);
    }

    public double FBornXX() {
        return 0.0;
    }

    public double getEps() {
        return this.eps;
    }

    public double getEpsIonic() {
        return this.epsIonic;
    }

    public double getEpsIonicdV() {
        return this.epsIonicdV;
    }

    public double getEpsdV() {
        return this.epsdV;
    }

    public double getEpsdVdV() {
        return this.epsdVdV;
    }

    public double getSolventDiElectricConstant() {
        return this.solventDiElectricConstant;
    }

    public double getSolventDiElectricConstantdT() {
        return this.solventDiElectricConstantdT;
    }

    public double getSolventDiElectricConstantdTdT() {
        return this.solventDiElectricConstantdTdT;
    }

    public double getAlphaLR2() {
        return this.alphaLR2;
    }

    public double getW() {
        return this.W;
    }

    public double getWT() {
        return this.WT;
    }

    public double getDiElectricConstantdT() {
        return this.diElectricConstantdT;
    }

    public double getDiElectricConstantdV() {
        return this.diElectricConstantdV;
    }

    public double getXLR() {
        return this.XLR;
    }

    public double getShieldingParameter() {
        return this.shieldingParameter;
    }

    public double getAlphaLRT() {
        return this.alphaLRdT;
    }

    public double getAlphaLRV() {
        return this.alphaLRdV;
    }

    public double getDielectricT() {
        return this.diElectricConstantdT;
    }

    public double getDielectricV() {
        return this.diElectricConstantdV;
    }

    public double getDielectricConstant() {
        return this.diElectricConstant;
    }

    public void setFurstIonicCoefficient(double[] params) {
    }

    public double getEpsIonicdVdV() {
        return this.epsIonicdVdV;
    }
}

