/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.component.ComponentHydrateGF;
import neqsim.thermo.component.ComponentHydratePVTsim;
import neqsim.thermo.phase.Phase;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class PhaseHydrate
extends Phase {
    private static final long serialVersionUID = 1000L;
    String hydrateModel = "PVTsimHydrateModel";

    public PhaseHydrate() {
        this.phaseTypeName = "hydrate";
    }

    public PhaseHydrate(String fluidModel) {
        this.hydrateModel = fluidModel.isEmpty() ? "PVTsimHydrateModel" : (fluidModel.equals("CPAs-SRK-EOS-statoil") || fluidModel.equals("CPAs-SRK-EOS") || fluidModel.equals("CPA-SRK-EOS") ? "CPAHydrateModel" : "PVTsimHydrateModel");
    }

    @Override
    public PhaseHydrate clone() {
        PhaseHydrate clonedPhase = null;
        try {
            clonedPhase = (PhaseHydrate)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedPhase;
    }

    @Override
    public double molarVolume(double pressure, double temperature, double A, double B, int phase) throws IsNaNException, TooManyIterationsException {
        double sum = 1.0;
        int hydrateStructure = ((ComponentHydrate)this.getComponent(0)).getHydrateStructure();
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < this.numberOfComponents; ++i) {
                sum += ((ComponentHydrate)this.getComponent(i)).getCavprwat(hydrateStructure, j) * ((ComponentHydrate)this.getComponent(i)).calcYKI(hydrateStructure, j, this);
            }
        }
        return sum / ((ComponentHydrate)this.getComponent(0)).getMolarVolumeHydrate(hydrateStructure, temperature);
    }

    @Override
    public void addcomponent(String componentName, double molesInPhase, double moles, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = this.hydrateModel.equals("CPAHydrateModel") ? new ComponentHydrateGF(componentName, moles, molesInPhase, compNumber) : new ComponentHydratePVTsim(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public void resetMixingRule(int type) {
    }

    public void setSolidRefFluidPhase(PhaseInterface refPhase) {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            if (!this.componentArray[i].getName().equals("water")) continue;
            ((ComponentHydrate)this.componentArray[i]).setSolidRefFluidPhase(refPhase);
        }
    }
}

