/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.phase;

import neqsim.thermo.component.ComponentGEWilson;
import neqsim.thermo.phase.PhaseGE;
import neqsim.thermo.phase.PhaseInterface;

public class PhaseGEWilson
extends PhaseGE {
    private static final long serialVersionUID = 1000L;
    double GE = 0.0;

    public PhaseGEWilson() {
        this.componentArray = new ComponentGEWilson[100];
    }

    public PhaseGEWilson(PhaseInterface phase, double[][] alpha, double[][] Dij, String[][] mixRule, double[][] intparam) {
        this.componentArray = new ComponentGEWilson[alpha[0].length];
        for (int i = 0; i < alpha[0].length; ++i) {
            ++this.numberOfComponents;
            this.componentArray[i] = new ComponentGEWilson(phase.getComponents()[i].getName(), phase.getComponents()[i].getNumberOfmoles(), phase.getComponents()[i].getNumberOfMolesInPhase(), phase.getComponents()[i].getComponentNumber());
        }
    }

    @Override
    public void addcomponent(String componentName, double moles, double molesInPhase, int compNumber) {
        super.addcomponent(molesInPhase);
        this.componentArray[compNumber] = new ComponentGEWilson(componentName, moles, molesInPhase, compNumber);
    }

    @Override
    public void setMixingRule(int type) {
        super.setMixingRule(type);
    }

    @Override
    public void init(double totalNumberOfMoles, int numberOfComponents, int type, int phase, double beta) {
        super.init(totalNumberOfMoles, numberOfComponents, type, phase, beta);
    }

    @Override
    public double getExessGibbsEnergy(PhaseInterface phase, int numberOfComponents, double temperature, double pressure, int phasetype) {
        this.GE = 0.0;
        for (int i = 0; i < numberOfComponents; ++i) {
            this.GE += phase.getComponents()[i].getx() * Math.log(((ComponentGEWilson)this.componentArray[i]).getWilsonActivityCoefficient(phase));
        }
        return 8.3144621 * temperature * this.numberOfMolesInPhase * this.GE;
    }

    @Override
    public double getGibbsEnergy() {
        return 8.3144621 * this.temperature * this.numberOfMolesInPhase * (this.GE + Math.log(this.pressure));
    }

    @Override
    public double getExessGibbsEnergy() {
        return this.GE;
    }
}

