/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentSrk;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;

public class ComponentSolid
extends ComponentSrk {
    private static final long serialVersionUID = 1000L;
    double dpdt = 1.0;
    double SolidFug = 0.0;
    double PvapSolid = 0.0;
    double PvapSoliddT = 0.0;
    double solvol = 0.0;
    double soldens = 0.0;
    boolean CCequation = true;
    boolean AntoineSolidequation = true;
    PhaseInterface refPhase = null;
    double pureCompFug = 0.0;

    public ComponentSolid(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    @Override
    public double fugcoef(PhaseInterface phase1) {
        if (!this.solidCheck) {
            // empty if block
        }
        if (this.componentName.equals("methane")) {
            return 1.0E30;
        }
        return this.fugcoef2(phase1);
    }

    public double fugcoef2(PhaseInterface phase1) {
        this.refPhase.setTemperature(phase1.getTemperature());
        this.refPhase.setPressure(phase1.getPressure());
        this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 1, 0, 1.0);
        this.refPhase.getComponent(0).fugcoef(this.refPhase);
        double liquidPhaseFugacity = this.refPhase.getComponent(0).getFugacityCoefficient() * this.refPhase.getPressure();
        double deltaCpSL = -(this.getPureComponentCpSolid(this.getTriplePointTemperature()) - this.getPureComponentCpLiquid(this.getTriplePointTemperature()));
        if (this.componentName.equals("water")) {
            deltaCpSL = 37.12;
        }
        double liqMolVol = 0.0;
        double solMolVol = 0.0;
        double temp = this.getPureComponentLiquidDensity(this.getTriplePointTemperature());
        liqMolVol = temp > 1.0E-20 ? 1.0 / temp * this.getMolarMass() : 1.0 / this.refPhase.getDensity() * this.getMolarMass();
        temp = this.getPureComponentSolidDensity(this.getTriplePointTemperature());
        solMolVol = temp > 1.0E-20 ? 1.0 / temp * this.getMolarMass() : liqMolVol;
        double deltaSolVol = solMolVol - liqMolVol;
        this.SolidFug = this.getx() * liquidPhaseFugacity * Math.exp(-this.getHeatOfFusion() / (8.3144621 * phase1.getTemperature()) * (1.0 - phase1.getTemperature() / this.getTriplePointTemperature()) + deltaCpSL / (8.3144621 * phase1.getTemperature()) * (this.getTriplePointTemperature() - phase1.getTemperature()) - deltaCpSL / 8.3144621 * Math.log(this.getTriplePointTemperature() / phase1.getTemperature()) - deltaSolVol * (1.0 - phase1.getPressure()) / (8.3144621 * phase1.getTemperature()));
        this.fugacityCoefficient = this.SolidFug / (phase1.getPressure() * this.getx());
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double fugcoef(double temp, double pres) {
        if (Math.abs(this.Hsub) < 1.0E-6) {
            this.CCequation = false;
        }
        if (Math.abs(this.AntoineASolid) < 1.0E-6) {
            this.AntoineSolidequation = false;
        }
        if (this.CCequation || this.AntoineSolidequation) {
            if (temp > this.getTriplePointTemperature() + 0.1) {
                temp = this.getTriplePointTemperature();
            }
            if (this.CCequation) {
                this.PvapSolid = this.getCCsolidVaporPressure(temp);
                this.PvapSoliddT = this.getCCsolidVaporPressuredT(temp);
            } else {
                this.PvapSolid = this.getSolidVaporPressure(temp);
                this.PvapSoliddT = this.getSolidVaporPressuredT(temp);
            }
        }
        this.soldens = this.getPureComponentSolidDensity(temp) * 1000.0;
        this.soldens = 1000.0;
        this.solvol = 1.0 / this.soldens * this.getMolarMass();
        this.refPhase.setTemperature(temp);
        this.refPhase.setPressure(this.PvapSolid);
        this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 1, 1, 1.0);
        this.refPhase.getComponent(0).fugcoef(this.refPhase);
        this.SolidFug = this.PvapSolid * Math.exp(this.solvol / (8.3144621 * temp) * (pres - this.PvapSolid) * 100000.0) * this.refPhase.getComponent(0).getFugacityCoefficient();
        this.dfugdt = Math.log(this.PvapSoliddT * Math.exp(this.solvol / (8.3144621 * temp) * (pres - this.PvapSolid))) / pres;
        this.fugacityCoefficient = this.SolidFug / pres;
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double getMolarVolumeSolid() {
        return this.getPureComponentSolidDensity(this.getMeltingPointTemperature()) / this.molarMass;
    }

    public void setSolidRefFluidPhase(PhaseInterface phase) {
        block4: {
            try {
                if ((this.isTBPfraction || this.isPlusFraction) && !NeqSimDataBase.createTemporaryTables()) break block4;
                this.refPhase = (PhaseInterface)phase.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.refPhase.setTemperature(273.0);
                this.refPhase.setPressure(1.0);
                try {
                    this.refPhase.addcomponent(this.componentName, 10.0, 10.0, 0);
                }
                catch (Exception e) {
                    logger.error("error occured in setSolidRefFluidPhase ", (Throwable)e);
                    this.refPhase.addcomponent("methane", 10.0, 10.0, 0);
                    this.refPhase.getComponent("methane").setComponentName(this.componentName);
                }
                this.refPhase.getComponent(this.componentName).setAttractiveTerm(phase.getComponent(this.componentName).getAttractiveTermNumber());
                this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 0, 1, 1.0);
            }
            catch (Exception e) {
                logger.error("error occured", (Throwable)e);
            }
        }
    }

    public double getVolumeCorrection2() {
        return 0.0;
    }
}

