/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermRk;

public class ComponentRK
extends ComponentEos {
    private static final long serialVersionUID = 1000L;

    public ComponentRK(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.a = 1.0 / (9.0 * (Math.pow(2.0, 0.3333333333333333) - 1.0)) * 8.3144621 * 8.3144621 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
        this.b = (Math.pow(2.0, 0.3333333333333333) - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure;
        this.delta1 = 1.0;
        this.delta2 = 0.0;
        this.setAttractiveParameter(new AttractiveTermRk(this));
    }

    public ComponentRK(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentRK clone() {
        ComponentRK clonedComponent = null;
        try {
            clonedComponent = (ComponentRK)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double calca() {
        return 1.0 / (9.0 * (Math.pow(2.0, 0.3333333333333333) - 1.0)) * 8.3144621 * 8.3144621 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calcb() {
        return (Math.pow(2.0, 0.3333333333333333) - 1.0) / 3.0 * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double getVolumeCorrection() {
        return 0.0;
    }

    public double getQpure(double temperature) {
        return this.getaT() / (this.getb() * 8.3144621 * temperature);
    }

    public double getdQpuredT(double temperature) {
        return this.dqPuredT;
    }

    public double getdQpuredTdT(double temperature) {
        return this.dqPuredTdT;
    }
}

