/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentEos;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermPr;

public class ComponentPR
extends ComponentEos {
    private static final long serialVersionUID = 1000L;

    public ComponentPR(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.a = 31.609359666876976 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
        this.b = 0.6468928634821793 * this.criticalTemperature / this.criticalPressure;
        this.delta1 = 1.0 + Math.sqrt(2.0);
        this.delta2 = 1.0 - Math.sqrt(2.0);
        this.setAttractiveParameter(new AttractiveTermPr(this));
        double[] surfTensInfluenceParamtemp = new double[]{1.3192, 1.6606, 1.1173, 0.8443};
        this.surfTensInfluenceParam = surfTensInfluenceParamtemp;
    }

    public ComponentPR(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentPR clone() {
        ComponentPR clonedComponent = null;
        try {
            clonedComponent = (ComponentPR)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double calca() {
        return 31.609359666876976 * this.criticalTemperature * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double calcb() {
        return 0.6468928634821793 * this.criticalTemperature / this.criticalPressure;
    }

    @Override
    public double getVolumeCorrection() {
        if (this.ionicCharge != 0) {
            return 0.0;
        }
        if (Math.abs(this.getVolumeCorrectionConst()) > 1.0E-10) {
            return this.getVolumeCorrectionConst() * this.b;
        }
        if (Math.abs(this.getRacketZ()) < 1.0E-10) {
            this.racketZ = 0.29056 - 0.08775 * this.getAcentricFactor();
        }
        return 0.50033 * (0.25969 - this.getRacketZ()) * 8.3144621 * this.criticalTemperature / this.criticalPressure;
    }

    public double getQpure(double temperature) {
        return this.getaT() / (this.getb() * 8.3144621 * temperature);
    }

    public double getdQpuredT(double temperature) {
        return this.dqPuredT;
    }

    public double getdQpuredTdT(double temperature) {
        return this.dqPuredTdT;
    }

    @Override
    public double getSurfaceTenisionInfluenceParameter(double temperature) {
        double TR = 1.0 - temperature / this.getTC();
        if (TR < 0.0) {
            TR = 0.5;
        }
        double AA = -1.0E-16 / (this.surfTensInfluenceParam[0] + this.surfTensInfluenceParam[1] * this.getAcentricFactor());
        double BB = 1.0E-16 / (this.surfTensInfluenceParam[2] + this.surfTensInfluenceParam[3] * this.getAcentricFactor());
        if (this.componentName.equals("water")) {
            AA = -6.99632E-17;
            BB = 5.68347E-17;
        }
        if (this.componentName.equals("MEG")) {
            return 7.101030813216131E-20;
        }
        return this.aT * 1.0E-5 * Math.pow(this.b * 1.0E-5, 0.6666666666666666) * (AA * TR + BB);
    }
}

