/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.util.LinkedHashMap;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.atomElement.Element;
import neqsim.thermo.component.attractiveEosTerm.AttractiveTermInterface;
import neqsim.thermo.phase.PhaseInterface;

public interface ComponentInterface
extends ThermodynamicConstantsInterface,
Cloneable {
    public boolean isInert();

    public void setIdealGasEnthalpyOfFormation(double var1);

    public String getFormulae();

    public double getVolumeCorrectionT();

    public void setVolumeCorrectionT(double var1);

    public double getVolumeCorrectionConst();

    public String getCASnumber();

    public void setVolumeCorrectionConst(double var1);

    public double getPureComponentCpLiquid(double var1);

    public double getPureComponentCpSolid(double var1);

    public double getdrhodN();

    public double getVolumeCorrectionT_CPA();

    public double getFlowRate(String var1);

    public double getTotalFlowRate(String var1);

    public void setVolumeCorrectionT_CPA(double var1);

    public void setNumberOfAssociationSites(int var1);

    public void setCASnumber(String var1);

    public void setFormulae(String var1);

    public void insertComponentIntoDatabase(String var1);

    public int getOrginalNumberOfAssociationSites();

    public void createComponent(String var1, double var2, double var4, int var6);

    public double getRacketZCPA();

    public void setRacketZCPA(double var1);

    public boolean isHydrocarbon();

    public void setComponentName(String var1);

    public double getChemicalPotentialdP();

    public void setHeatOfFusion(double var1);

    public double getChemicalPotentialIdealReference(PhaseInterface var1);

    public double getHeatOfFusion();

    public void setSurfTensInfluenceParam(int var1, double var2);

    public boolean isWaxFormer();

    public void setWaxFormer(boolean var1);

    public double getSurfTensInfluenceParam(int var1);

    public double getChemicalPotentialdN(int var1, PhaseInterface var2);

    public double getChemicalPotential(PhaseInterface var1);

    public double getChemicalPotentialdT(PhaseInterface var1);

    public double getChemicalPotentialdNTV(int var1, PhaseInterface var2);

    public void setTriplePointTemperature(double var1);

    public void setComponentType(String var1);

    public void seta(double var1);

    public double getSphericalCoreRadius();

    public void setb(double var1);

    public int getNumberOfAssociationSites();

    public String getComponentType();

    public double getRate(String var1);

    public double fugcoef(PhaseInterface var1);

    public double logfugcoefdT(PhaseInterface var1);

    public double logfugcoefdNi(PhaseInterface var1, int var2);

    public void setStokesCationicDiameter(double var1);

    public double logfugcoefdP(PhaseInterface var1);

    public double[] logfugcoefdN(PhaseInterface var1);

    public void setProperties(ComponentInterface var1);

    public double getTripplePointDensity();

    public void setFugacityCoefficient(double var1);

    public double getCriticalCompressibilityFactor();

    public void setCriticalCompressibilityFactor(double var1);

    public void setMolarMass(double var1);

    public boolean calcActivity();

    public double getMolality(PhaseInterface var1);

    public void setLennardJonesMolecularDiameter(double var1);

    public void setLennardJonesEnergyParameter(double var1);

    public void setSphericalCoreRadius(double var1);

    public double getTriplePointPressure();

    public double getTriplePointTemperature();

    public double getMeltingPointTemperature();

    public double getIdealGasEnthalpyOfFormation();

    public void addMolesChemReac(double var1);

    public void addMolesChemReac(double var1, double var3);

    public double getIdealGasGibsEnergyOfFormation();

    public void setTC(double var1);

    public void setPC(double var1);

    public double getDiElectricConstantdTdT(double var1);

    public double getIdealGasAbsoluteEntropy();

    public double getDiElectricConstantdT(double var1);

    public void init(double var1, double var3, double var5, double var7, int var9);

    public void Finit(PhaseInterface var1, double var2, double var4, double var6, double var8, int var10, int var11);

    public double getx();

    public double getz();

    public double getK();

    public double getTC();

    public double getNormalBoilingPoint();

    public void setNormalBoilingPoint(double var1);

    public double getPC();

    public void setComponentNumber(int var1);

    public void setViscosityAssociationFactor(double var1);

    public int getIndex();

    public String getReferenceStateType();

    public void setLiquidConductivityParameter(double var1, int var3);

    public double getLiquidConductivityParameter(int var1);

    public double getNormalLiquidDensity();

    public String getComponentName();

    public int getComponentNumber();

    public double getHeatOfVapourization(double var1);

    public double getNumberOfmoles();

    public void addMoles(double var1);

    public double getGibbsEnergyOfFormation();

    public double getReferencePotential();

    public double getLogFugacityCoefficient();

    public void setReferencePotential(double var1);

    public double getNumberOfMolesInPhase();

    public void setNumberOfMolesInPhase(double var1);

    public double getIdEntropy(double var1);

    public void setx(double var1);

    public void setz(double var1);

    public void setK(double var1);

    public double getDiElectricConstant(double var1);

    public double getIonicCharge();

    public double getdfugdt();

    public double getdfugdp();

    public double getSolidVaporPressure(double var1);

    public double getCp0(double var1);

    public double getCv0(double var1);

    public double getHID(double var1);

    public double getEnthalpy(double var1);

    public double getMolarMass();

    public double getLennardJonesMolecularDiameter();

    public double getLennardJonesEnergyParameter();

    public double getEntropy(double var1, double var3);

    public double getdfugdx(int var1);

    public double getdfugdn(int var1);

    public double getHresTP(double var1);

    public double getGresTP(double var1);

    public double getSresTP(double var1);

    public double getFugacityCoefficient();

    public double getAcentricFactor();

    public void setAttractiveTerm(int var1);

    public AttractiveTermInterface getAttractiveTerm();

    public void setNumberOfmoles(double var1);

    public double getAntoineVaporPressure(double var1);

    public double getAntoineVaporTemperature(double var1);

    public double getSolidVaporPressuredT(double var1);

    public double getChemicalPotential(double var1, double var3);

    public double getGibbsEnergy(double var1, double var3);

    public ComponentInterface clone();

    public double getDebyeDipoleMoment();

    public double getViscosityCorrectionFactor();

    public double getCriticalVolume();

    public double getRacketZ();

    public String getName();

    public double getLiquidViscosityParameter(int var1);

    public int getLiquidViscosityModel();

    public void setAcentricFactor(double var1);

    public double getVolumeCorrection();

    public void setRacketZ(double var1);

    public void setLiquidViscosityModel(int var1);

    public void setLiquidViscosityParameter(double var1, int var3);

    public Element getElements();

    public double[] getSchwartzentruberParams();

    public void setSchwartzentruberParams(int var1, double var2);

    public double[] getTwuCoonParams();

    public void setTwuCoonParams(int var1, double var2);

    public double getParachorParameter();

    public void setParachorParameter(double var1);

    public double getPureComponentSolidDensity(double var1);

    public double getPureComponentLiquidDensity(double var1);

    public double getChemicalPotentialdV(PhaseInterface var1);

    public double getPureComponentHeatOfVaporization(double var1);

    public double fugcoefDiffPresNumeric(PhaseInterface var1, int var2, double var3, double var5);

    public double fugcoefDiffTempNumeric(PhaseInterface var1, int var2, double var3, double var5);

    public void setdfugdt(double var1);

    public void setdfugdp(double var1);

    public void setdfugdn(int var1, double var2);

    public void setdfugdx(int var1, double var2);

    public double getPaulingAnionicDiameter();

    public double getStokesCationicDiameter();

    public int getAttractiveTermNumber();

    public double getVoli();

    public double getAntoineVaporPressuredT(double var1);

    public double[] getMatiascopemanParams();

    public void setMatiascopemanParams(int var1, double var2);

    public void setMatiascopemanParams(double[] var1);

    public double getAssociationVolume();

    public void setAssociationVolume(double var1);

    public double getAssociationEnergy();

    public void setAssociationEnergy(double var1);

    public double getAntoineASolid();

    public void setAntoineASolid(double var1);

    public double getAntoineBSolid();

    public void setAntoineBSolid(double var1);

    public boolean isIsTBPfraction();

    public void setIsTBPfraction(boolean var1);

    public boolean isIsPlusFraction();

    public void setIsPlusFraction(boolean var1);

    public boolean isIsNormalComponent();

    public void setIsNormalComponent(boolean var1);

    public boolean isIsIon();

    public void setIsIon(boolean var1);

    public void setNormalLiquidDensity(double var1);

    public boolean doSolidCheck();

    public void setSolidCheck(boolean var1);

    public String getAssociationScheme();

    public void setAssociationScheme(String var1);

    public double getAntoineCSolid();

    public void setAntoineCSolid(double var1);

    public double getCCsolidVaporPressure(double var1);

    public double getCCsolidVaporPressuredT(double var1);

    public double getHsub();

    public double[] getHenryCoefParameter();

    public void setHenryCoefParameter(double[] var1);

    public double getHenryCoef(double var1);

    public double getHenryCoefdT(double var1);

    public double[] getMatiascopemanSolidParams();

    public void setCriticalVolume(double var1);

    public double getCriticalViscosity();

    public void setCriticalViscosity(double var1);

    public double getMolarity(PhaseInterface var1);

    public boolean isHydrateFormer();

    public void setIsHydrateFormer(boolean var1);

    public double getmSAFTi();

    public void setmSAFTi(double var1);

    public double getSigmaSAFTi();

    public void setSigmaSAFTi(double var1);

    public double getEpsikSAFT();

    public void setEpsikSAFT(double var1);

    public double getAssociationVolumeSAFT();

    public void setAssociationVolumeSAFT(double var1);

    public double getAssociationEnergySAFT();

    public void setAssociationEnergySAFT(double var1);

    public double getSurfaceTenisionInfluenceParameter(double var1);

    public double getCpA();

    public void setCpA(double var1);

    public double getCpB();

    public void setCpB(double var1);

    public double getCpC();

    public void setCpC(double var1);

    public double getCpD();

    public void setCpD(double var1);

    public double getCpE();

    public void setCpE(double var1);

    public static String getComponentName(String name) {
        LinkedHashMap<String, String> c = ComponentInterface.getComponentMap();
        if (c.containsKey(name)) {
            return c.get(name);
        }
        return name;
    }

    public static LinkedHashMap<String, String> getComponentMap() {
        LinkedHashMap<String, String> c = new LinkedHashMap<String, String>();
        c.put("H2O", "water");
        c.put("N2", "nitrogen");
        c.put("C1", "methane");
        c.put("C2", "ethane");
        c.put("C3", "propane");
        c.put("iC4", "i-butane");
        c.put("nC4", "n-butane");
        c.put("iC5", "i-pentane");
        c.put("nC5", "n-pentane");
        c.put("C6", "n-hexane");
        c.put("O2", "oxygen");
        c.put("He", "helium");
        c.put("H2", "hydrogen");
        c.put("Ar", "argon");
        c.put("H2S", "H2S");
        c.put("nC7", "n-heptane");
        c.put("nC8", "n-octane");
        c.put("nC9", "n-nonane");
        return c;
    }
}

