/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.ComponentHydrate;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydrateGF
extends ComponentHydrate {
    private static final long serialVersionUID = 1000L;
    double[][] Ak = new double[2][2];
    double[][] Bk = new double[2][2];
    static Logger logger = LogManager.getLogger(ComponentHydrateGF.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHydrateGF(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = null;
        if (!component_name.equals("default")) {
            try {
                try {
                    dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                    dataSet.next();
                    dataSet.getString("ID");
                }
                catch (Exception e) {
                    logger.info("no parameters in tempcomp -- trying comp.. " + component_name);
                    dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                    dataSet.next();
                }
                this.Ak[0][0] = Double.parseDouble(dataSet.getString("A1_SmallGF"));
                this.Bk[0][0] = Double.parseDouble(dataSet.getString("B1_SmallGF"));
                this.Ak[0][1] = Double.parseDouble(dataSet.getString("A1_LargeGF"));
                this.Bk[0][1] = Double.parseDouble(dataSet.getString("B1_LargeGF"));
                this.Ak[1][0] = Double.parseDouble(dataSet.getString("A2_SmallGF"));
                this.Bk[1][0] = Double.parseDouble(dataSet.getString("B2_SmallGF"));
                this.Ak[1][1] = Double.parseDouble(dataSet.getString("A2_LargeGF"));
                this.Bk[1][1] = Double.parseDouble(dataSet.getString("B2_LargeGF"));
                dataSet.close();
            }
            catch (Exception e) {
                logger.error("error in ComponentHydrateGF", (Throwable)e);
            }
            finally {
                try {
                    dataSet.close();
                    database.getConnection().close();
                }
                catch (Exception e) {
                    logger.error("error closing database.....");
                }
            }
        }
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        return this.fugcoef(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    public double fugcoef2(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            double solvol = this.getMolarVolumeHydrate(this.hydrateStructure, temp);
            if (this.hydrateStructure == -1) {
                this.fugacityCoefficient = this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
            } else {
                double val = 0.0;
                double tempy = 1.0;
                for (int cavType = 0; cavType < 2; ++cavType) {
                    tempy = 0.0;
                    for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                        double tee = ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                        tempy += tee;
                    }
                    val += this.getCavprwat()[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                }
                this.fugacityCoefficient = Math.exp(val) * this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
            }
        } else {
            this.fugacityCoefficient = 1.0E50;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    @Override
    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        double maxFug = 1.0E100;
        int stableStructure = 0;
        if (this.hydrateStructure == -1) {
            stableStructure = -1;
            this.refPhase.setTemperature(temp);
            this.refPhase.setPressure(pres);
            this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 3, 0, 1.0);
            double refWaterFugacityCoef = Math.log(this.refPhase.getComponent("water").fugcoef(this.refPhase));
            double dhf = 6010.0;
            double tmi = 273.15;
            double dcp = 37.29;
            double LNFUG_ICEREF = refWaterFugacityCoef - dhf / (8.3144621 * tmi) * (tmi / temp - 1.0) + dcp / 8.3144621 * (tmi / temp - 1.0 - Math.log(tmi / temp));
            double VM = 0.0;
            double K1 = 1.607E-4;
            double K2 = 3.4619E-7;
            double K3 = -2.637E-11;
            VM = 1.96522E-5 * (1.0 + K1 * (temp - tmi) + K2 * Math.pow(temp - tmi, 2.0) + K3 * Math.pow(temp - tmi, 3.0));
            double LNFUG_ICE = LNFUG_ICEREF + VM * 100000.0 * (pres - 1.0) / (8.3144621 * temp);
            this.fugacityCoefficient = Math.exp(LNFUG_ICE);
        } else {
            for (int structure = 0; structure < 2; ++structure) {
                this.hydrateStructure = structure;
                if (this.componentName.equals("water")) {
                    double solvol = this.getMolarVolumeHydrate(this.hydrateStructure, temp);
                    double val = 0.0;
                    double tempy = 1.0;
                    for (int cavType = 0; cavType < 2; ++cavType) {
                        tempy = 0.0;
                        for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                            double tee = ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                            tempy += tee;
                        }
                        val += this.getCavprwat()[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                    }
                    this.fugacityCoefficient = Math.exp(val) * this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
                    if (!(this.fugacityCoefficient < maxFug)) continue;
                    maxFug = this.fugacityCoefficient;
                    stableStructure = this.hydrateStructure;
                    continue;
                }
                this.fugacityCoefficient = 1.0E50;
            }
            this.fugacityCoefficient = maxFug;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        this.hydrateStructure = stableStructure;
        return this.fugacityCoefficient;
    }

    @Override
    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber];
        double temp = 1.0;
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            if (!phase.getComponent(i).isHydrateFormer()) continue;
            temp += ((ComponentHydrate)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * this.reffug[i];
        }
        return yki / temp;
    }

    @Override
    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        return this.Ak[stucture][cavityType] / phase.getTemperature() * Math.exp(this.Bk[stucture][cavityType] / phase.getTemperature());
    }
}

