/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import java.sql.ResultSet;
import neqsim.thermo.component.Component;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.phase.PhaseInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentHydrate
extends Component {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ComponentHydrate.class);
    double[][] emptyHydrateVapourPressureConstant;
    int hydrateStructure;
    double[][] coordNumb;
    double[][] cavRadius;
    double[][] cavNumb;
    double[][] cavprwat;
    double[] dGfHydrate;
    double[] dHfHydrate;
    double[] reffug;
    private double sphericalCoreRadiusHydrate;
    private double lennardJonesEnergyParameterHydrate;
    private double lennardJonesMolecularDiameterHydrate;
    PhaseInterface refPhase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComponentHydrate(String component_name, double moles, double molesInPhase, int compnumber) {
        block16: {
            super(component_name, moles, molesInPhase, compnumber);
            this.emptyHydrateVapourPressureConstant = new double[][]{{17.44, -6003.9}, {17.332, -6017.6}};
            this.hydrateStructure = 0;
            this.coordNumb = new double[2][2];
            this.cavRadius = new double[2][2];
            this.cavNumb = new double[2][2];
            this.cavprwat = new double[2][2];
            this.dGfHydrate = new double[]{-235557.0, -235614.0};
            this.dHfHydrate = new double[]{-291786.0, -292016.0};
            this.reffug = new double[100];
            this.sphericalCoreRadiusHydrate = 0.0;
            this.lennardJonesEnergyParameterHydrate = 0.0;
            this.lennardJonesMolecularDiameterHydrate = 0.0;
            this.refPhase = null;
            this.coordNumb[0][0] = 20.0;
            this.coordNumb[0][1] = 24.0;
            this.cavRadius[0][0] = 3.95;
            this.cavRadius[0][1] = 4.33;
            this.cavNumb[0][0] = 2.0;
            this.cavNumb[0][1] = 6.0;
            this.cavprwat[0][0] = 0.043478260869565216;
            this.cavprwat[0][1] = 0.13043478260869565;
            this.coordNumb[1][0] = 20.0;
            this.coordNumb[1][1] = 28.0;
            this.cavRadius[1][0] = 3.91;
            this.cavRadius[1][1] = 4.73;
            this.cavNumb[1][0] = 16.0;
            this.cavNumb[1][1] = 8.0;
            this.cavprwat[1][0] = 0.11764705882352941;
            this.cavprwat[1][1] = 0.058823529411764705;
            this.reffug[0] = 10.0;
            this.reffug[1] = 1.0;
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            try {
                if (component_name.equals("default")) break block16;
                try {
                    dataSet = NeqSimDataBase.createTemporaryTables() ? database.getResultSet("SELECT * FROM comptemp WHERE name='" + component_name + "'") : database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                    dataSet.next();
                    dataSet.getString("FORMULA");
                }
                catch (Exception e) {
                    dataSet.close();
                    logger.info("no parameters in tempcomp -- trying comp.. " + component_name);
                    dataSet = database.getResultSet("SELECT * FROM comp WHERE name='" + component_name + "'");
                    dataSet.next();
                }
                this.lennardJonesMolecularDiameterHydrate = Double.parseDouble(dataSet.getString("LJdiameterHYDRATE"));
                this.lennardJonesEnergyParameterHydrate = Double.parseDouble(dataSet.getString("LJepsHYDRATE"));
                this.sphericalCoreRadiusHydrate = Double.parseDouble(dataSet.getString("SphericalCoreRadiusHYDRATE"));
            }
            catch (Exception e) {
                logger.error("error in comp", (Throwable)e);
            }
            finally {
                try {
                    if (dataSet != null) {
                        dataSet.close();
                    }
                    if (database.getStatement() != null) {
                        database.getStatement().close();
                    }
                    if (database.getConnection() != null) {
                        database.getConnection().close();
                    }
                }
                catch (Exception e) {
                    logger.error("error closing database.....", (Throwable)e);
                }
            }
        }
    }

    public void readHydrateParameters() {
    }

    @Override
    public double fugcoef(PhaseInterface phase) {
        return this.fugcoef(phase, phase.getNumberOfComponents(), phase.getTemperature(), phase.getPressure());
    }

    public void setHydrateStructure(int structure) {
        this.hydrateStructure = structure;
    }

    public int getHydrateStructure() {
        return this.hydrateStructure;
    }

    public double fugcoef(PhaseInterface phase, int numberOfComps, double temp, double pres) {
        if (this.componentName.equals("water")) {
            this.fugacityCoefficient = -1.0E50;
            double val = 1.0;
            double tempy = 1.0;
            double fugold = 0.0;
            do {
                val = 0.0;
                tempy = 0.0;
                fugold = this.fugacityCoefficient;
                if (this.hydrateStructure >= 0) {
                    for (int cavType = 0; cavType < 2; ++cavType) {
                        tempy = 0.0;
                        for (int j = 0; j < phase.getNumberOfComponents(); ++j) {
                            tempy += ((ComponentHydrate)phase.getComponent(j)).calcYKI(this.hydrateStructure, cavType, phase);
                        }
                        val += this.getCavprwat()[this.hydrateStructure][cavType] * Math.log(1.0 - tempy);
                    }
                }
                double solvol = 0.0011037527593818985 * this.getMolarMass();
                this.fugacityCoefficient = Math.exp(val) * this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp) * Math.exp(solvol / (8.3144621 * temp) * (pres - this.getEmptyHydrateStructureVapourPressure(this.hydrateStructure, temp)) * 100000.0) / pres;
            } while (Math.abs((this.fugacityCoefficient - fugold) / fugold) > 1.0E-6);
        } else {
            this.fugacityCoefficient = 100000.0;
        }
        this.logFugacityCoefficient = Math.log(this.fugacityCoefficient);
        return this.fugacityCoefficient;
    }

    public double getEmptyHydrateStructureVapourPressure(int type, double temperature) {
        if (type == -1) {
            return this.getSolidVaporPressure(temperature);
        }
        return Math.exp(this.getEmptyHydrateVapourPressureConstant(type, 0) + this.getEmptyHydrateVapourPressureConstant(type, 1) / temperature) * 1.01325;
    }

    public void setEmptyHydrateVapourPressureConstant(int hydrateStructure, int parameterNumber, double value) {
        this.emptyHydrateVapourPressureConstant[hydrateStructure][parameterNumber] = value;
    }

    public double getEmptyHydrateVapourPressureConstant(int hydrateStructure, int parameterNumber) {
        return this.emptyHydrateVapourPressureConstant[hydrateStructure][parameterNumber];
    }

    public double calcChemPotEmpty(PhaseInterface phase, int numberOfComps, double temp, double pres, int hydrateStruct) {
        double dGf = 0.0;
        double dHf = 0.0;
        double Cpa = this.getCpA();
        double Cpb = this.getCpB();
        double Cpc = this.getCpC();
        double Cpd = this.getCpD();
        double deltaMolarVolume = 0.0;
        if (hydrateStruct == 1) {
            dGf = this.getDGfHydrate()[1];
            dHf = this.getDHfHydrate()[1];
            deltaMolarVolume = 5.0E-6;
        } else {
            dGf = this.getDGfHydrate()[0];
            dHf = this.getDHfHydrate()[0];
            deltaMolarVolume = 4.6E-6;
        }
        double T0 = 298.15;
        return dGf / 8.3144621 / T0 + 1.0 * (dHf += Cpa * (temp - T0) + Cpb * Math.log(temp / T0) - Cpc * (1.0 / temp - 1.0 / T0) - 0.5 * Cpd * (1.0 / (temp * temp) - 1.0 / (T0 * T0))) * (0.1202723625380408 / temp - 0.1202723625380408 / T0) + deltaMolarVolume / 8.3144621 / ((temp + T0) / 2.0) * (pres * 100000.0 - 100000.0);
    }

    public double calcChemPotIdealWater(PhaseInterface phase, int numberOfComps, double temp, double pres, int hydrateStruct) {
        double dGf = -228700.0;
        double dHf = -242000.0;
        double Cpa = this.getCpA();
        double Cpb = this.getCpB();
        double Cpc = this.getCpC();
        double Cpd = this.getCpD();
        double T0 = 298.15;
        return dGf / 8.3144621 / T0 + 1.0 * (dHf += Cpa * (temp - T0) + Cpb * Math.log(temp / T0) - Cpc * (1.0 / temp - 1.0 / T0) - 0.5 * Cpd * (1.0 / (temp * temp) - 1.0 / (T0 * T0))) * (0.1202723625380408 / temp - 0.1202723625380408 / T0);
    }

    public double calcYKI(int stucture, int cavityType, PhaseInterface phase) {
        if (this.componentName.equals("water")) {
            return 0.0;
        }
        double yki = this.calcCKI(stucture, cavityType, phase) * this.reffug[this.componentNumber];
        double temp = 1.0;
        for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            if (phase.getComponent(i).getComponentName().equals("water") || !phase.getComponent(i).isHydrateFormer()) continue;
            temp += ((ComponentHydrate)phase.getComponent(i)).calcCKI(stucture, cavityType, phase) * this.reffug[i];
        }
        return yki / temp;
    }

    public double calcCKI(int stucture, int cavityType, PhaseInterface phase) {
        double cki = 12.5663706 / (1.38066E-23 * phase.getTemperature()) * this.potIntegral(stucture, cavityType, phase);
        return cki;
    }

    public void setRefFug(int compNumbm, double val) {
        this.reffug[compNumbm] = val;
    }

    public double potIntegral(int stucture, int cavityType, PhaseInterface phase) {
        double step;
        double val = 0.0;
        double endval = this.cavRadius[stucture][cavityType] - this.getSphericalCoreRadiusHydrate();
        double x = 0.0;
        x = step = endval / 100.0;
        for (int i = 1; i < 100; ++i) {
            val += step * ((this.getPot(x, stucture, cavityType, phase) + 4.0 * this.getPot(x + 0.5 * step, stucture, cavityType, phase) + this.getPot(x + step, stucture, cavityType, phase)) / 6.0);
            x = (double)i * step;
        }
        return val / 100000.0;
    }

    public double getPot(double radius, int struccture, int cavityType, PhaseInterface phase) {
        double pot = 2.0 * this.coordNumb[struccture][cavityType] * this.getLennardJonesEnergyParameterHydrate() * (Math.pow(this.getLennardJonesMolecularDiameterHydrate(), 12.0) / (Math.pow(this.cavRadius[struccture][cavityType], 11.0) * radius) * (this.delt(10.0, radius, struccture, cavityType, this) + this.getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType] * this.delt(11.0, radius, struccture, cavityType, this)) - Math.pow(this.getLennardJonesMolecularDiameterHydrate(), 6.0) / (Math.pow(this.cavRadius[struccture][cavityType], 5.0) * radius) * (this.delt(4.0, radius, struccture, cavityType, this) + this.getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType] * this.delt(5.0, radius, struccture, cavityType, this)));
        pot = Math.exp(-pot / phase.getTemperature()) * radius * radius / 1.0E20;
        return pot;
    }

    public double delt(double n, double radius, int struccture, int cavityType, ComponentInterface comp) {
        double delt = 1.0 / n * (Math.pow(1.0 - radius / this.cavRadius[struccture][cavityType] - ((ComponentHydrate)comp).getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType], -n) - Math.pow(1.0 + radius / this.cavRadius[struccture][cavityType] - ((ComponentHydrate)comp).getSphericalCoreRadiusHydrate() / this.cavRadius[struccture][cavityType], -n));
        return delt;
    }

    public double[] getDGfHydrate() {
        return this.dGfHydrate;
    }

    public void setDGfHydrate(double[] dGfHydrate) {
        this.dGfHydrate = dGfHydrate;
    }

    public void setDGfHydrate(double dGfHydrate, int i) {
        this.dGfHydrate[i] = dGfHydrate;
    }

    public void setDHfHydrate(double dHfHydrate, int i) {
        this.dHfHydrate[i] = dHfHydrate;
    }

    public double[] getDHfHydrate() {
        return this.dHfHydrate;
    }

    public void setDHfHydrate(double[] dHfHydrate) {
        this.dHfHydrate = dHfHydrate;
    }

    public double getMolarVolumeHydrate(int structure, double temperature) {
        double TO = 273.15;
        if (structure == 0) {
            double v0 = 22.35;
            double k1 = 3.1075E-4;
            double k2 = 5.9537E-7;
            double k3 = 1.3707E-10;
            return v0 * (1.0 + k1 * (temperature - TO) + k2 * Math.pow(temperature - TO, 2.0) + k3 * Math.pow(temperature - TO, 3.0)) / 1000000.0;
        }
        if (structure == 1) {
            double v0 = 22.57;
            double k1 = 1.9335E-4;
            double k2 = 2.1768E-7;
            double k3 = -1.4786E-10;
            return v0 * (1.0 + k1 * (temperature - TO) + k2 * Math.pow(temperature - TO, 2.0) + k3 * Math.pow(temperature - TO, 3.0)) / 1000000.0;
        }
        if (structure == -1) {
            double v0 = 19.6522;
            double k1 = 1.607E-4;
            double k2 = 3.4619E-7;
            double k3 = -1.4786E-10;
            return v0 * (1.0 + k1 * (temperature - TO) + k2 * Math.pow(temperature - TO, 2.0) + k3 * Math.pow(temperature - TO, 3.0)) / 1000000.0;
        }
        return 0.0;
    }

    public double getSphericalCoreRadiusHydrate() {
        return this.sphericalCoreRadiusHydrate;
    }

    public void setSphericalCoreRadiusHydrate(double sphericalCoreRadiusHydrate) {
        this.sphericalCoreRadiusHydrate = sphericalCoreRadiusHydrate;
    }

    public double getLennardJonesEnergyParameterHydrate() {
        return this.lennardJonesEnergyParameterHydrate;
    }

    public void setLennardJonesEnergyParameterHydrate(double lennardJonesEnergyParameterHydrate) {
        this.lennardJonesEnergyParameterHydrate = lennardJonesEnergyParameterHydrate;
    }

    public double getLennardJonesMolecularDiameterHydrate() {
        return this.lennardJonesMolecularDiameterHydrate;
    }

    public void setLennardJonesMolecularDiameterHydrate(double lennardJonesMolecularDiameterHydrate) {
        this.lennardJonesMolecularDiameterHydrate = lennardJonesMolecularDiameterHydrate;
    }

    public void setSolidRefFluidPhase(PhaseInterface phase) {
        try {
            this.refPhase = (PhaseInterface)phase.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.refPhase.setTemperature(273.0);
            this.refPhase.setPressure(1.0);
            this.refPhase.addcomponent("water", 10.0, 10.0, 0);
            this.refPhase.init(this.refPhase.getNumberOfMolesInPhase(), 1, 0, 1, 1.0);
        }
        catch (Exception e) {
            logger.error("error occured", (Throwable)e);
        }
    }

    public double getCavprwat(int structure, int cavityType) {
        return this.getCavprwat()[structure][cavityType];
    }

    public double[][] getCavprwat() {
        return this.cavprwat;
    }
}

