/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentElectrolyteCPA;
import neqsim.thermo.component.ComponentEosInterface;
import neqsim.thermo.phase.PhaseInterface;

public class ComponentElectrolyteCPAstatoil
extends ComponentElectrolyteCPA {
    private static final long serialVersionUID = 1000L;

    public ComponentElectrolyteCPAstatoil(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
    }

    public ComponentElectrolyteCPAstatoil(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
    }

    @Override
    public ComponentElectrolyteCPAstatoil clone() {
        ComponentElectrolyteCPAstatoil clonedComponent = null;
        try {
            clonedComponent = (ComponentElectrolyteCPAstatoil)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        return clonedComponent;
    }

    @Override
    public double calc_lngi(PhaseInterface phase) {
        return 0.475 / (1.0 - 0.475 * phase.getB() / phase.getTotalVolume()) * this.getBi() / phase.getTotalVolume();
    }

    @Override
    public double calc_lngidV(PhaseInterface phase) {
        double temp = phase.getTotalVolume() - 0.475 * phase.getB();
        return -0.475 * this.getBi() / (temp * temp);
    }

    @Override
    public double calc_lngij(int j, PhaseInterface phase) {
        double temp = phase.getTotalVolume() - 0.475 * phase.getB();
        return 0.475 * this.getBij(j) * 0.0 / (phase.getTotalVolume() - 0.475 * phase.getB()) - 0.475 * this.getBi() * 1.0 / (temp * temp) * (-0.475 * ((ComponentEosInterface)phase.getComponent(j)).getBi());
    }
}

