/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.component;

import neqsim.thermo.component.ComponentCPAInterface;
import neqsim.thermo.component.ComponentModifiedFurstElectrolyteEos;
import neqsim.thermo.phase.PhaseCPAInterface;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentElectrolyteCPAOld
extends ComponentModifiedFurstElectrolyteEos
implements ComponentCPAInterface {
    private static final long serialVersionUID = 1000L;
    int cpaon = 1;
    private double[][] xsitedni = new double[0][0];
    double[] xsite = new double[0];
    double[] xsiteOld = new double[0];
    double[] xsitedV = new double[0];
    double[] xsitedT = new double[0];
    static Logger logger = LogManager.getLogger(ComponentElectrolyteCPAOld.class);

    public ComponentElectrolyteCPAOld(String component_name, double moles, double molesInPhase, int compnumber) {
        super(component_name, moles, molesInPhase, compnumber);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            logger.info("ass sites: " + this.numberOfAssociationSites);
            logger.info("aSRK " + this.a + " aCPA " + this.aCPA);
            logger.info("bSRK " + this.b + " bCPA " + this.bCPA);
            for (int j = 0; j < this.getNumberOfAssociationSites(); ++j) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
            }
            if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
                this.a = this.aCPA;
                this.b = this.bCPA;
            }
            this.setAttractiveTerm(0);
        }
    }

    public ComponentElectrolyteCPAOld(int number, double TC, double PC, double M, double a, double moles) {
        super(number, TC, PC, M, a, moles);
        this.xsite = new double[this.numberOfAssociationSites];
        this.xsitedV = new double[this.numberOfAssociationSites];
        this.xsiteOld = new double[this.numberOfAssociationSites];
        this.xsitedT = new double[this.numberOfAssociationSites];
        if (this.numberOfAssociationSites != 0 && this.cpaon == 1) {
            for (int j = 0; j < this.getNumberOfAssociationSites(); ++j) {
                this.setXsite(j, 1.0);
                this.setXsiteOld(j, 1.0);
                this.setXsitedV(j, 0.0);
                this.setXsitedT(j, 0.0);
            }
            if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
                a = this.aCPA;
                this.b = this.bCPA;
            }
            this.setAttractiveTerm(0);
        }
    }

    @Override
    public ComponentElectrolyteCPAOld clone() {
        ComponentElectrolyteCPAOld clonedComponent = null;
        try {
            clonedComponent = (ComponentElectrolyteCPAOld)super.clone();
        }
        catch (Exception e) {
            logger.error("Cloning failed.", (Throwable)e);
        }
        clonedComponent.xsite = (double[])this.xsite.clone();
        System.arraycopy(this.xsite, 0, clonedComponent.xsite, 0, this.xsite.length);
        clonedComponent.xsiteOld = (double[])this.xsiteOld.clone();
        System.arraycopy(this.xsiteOld, 0, clonedComponent.xsiteOld, 0, this.xsiteOld.length);
        clonedComponent.xsitedV = (double[])this.xsitedV.clone();
        System.arraycopy(this.xsitedV, 0, clonedComponent.xsitedV, 0, this.xsitedV.length);
        clonedComponent.xsitedT = (double[])this.xsitedT.clone();
        System.arraycopy(this.xsitedT, 0, clonedComponent.xsitedT, 0, this.xsitedT.length);
        return clonedComponent;
    }

    @Override
    public void init(double temperature, double pressure, double totalNumberOfMoles, double beta, int type) {
        super.init(temperature, pressure, totalNumberOfMoles, beta, type);
    }

    @Override
    public double getVolumeCorrection() {
        if (this.aCPA > 1.0E-10 && this.cpaon == 1) {
            return 0.0;
        }
        return super.getVolumeCorrection();
    }

    @Override
    public void setAttractiveTerm(int i) {
        super.setAttractiveTerm(i);
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            this.getAttractiveTerm().setm(this.mCPA);
        }
    }

    @Override
    public void seta(double a) {
        this.aCPA = a;
    }

    @Override
    public void setb(double a) {
        this.bCPA = a;
    }

    @Override
    public double calca() {
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            return this.aCPA;
        }
        return super.calca();
    }

    @Override
    public double calcb() {
        if (Math.abs(this.aCPA) > 1.0E-6 && this.cpaon == 1) {
            return this.bCPA;
        }
        return super.calcb();
    }

    @Override
    public double dFdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double Fsup = super.dFdN(phase, numberOfComponents, temperature, pressure);
        double Fcpa = 0.0;
        Fcpa = this.dFCPAdN(phase, numberOfComponents, temperature, pressure);
        return Fsup + (double)this.cpaon * Fcpa;
    }

    @Override
    public double dFdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdT(phase, numberOfComponents, temperature, pressure) + this.dFCPAdNdT(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdV(phase, numberOfComponents, temperature, pressure) + this.dFCPAdNdV(phase, numberOfComponents, temperature, pressure);
    }

    @Override
    public double dFdNdN(int j, PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        return super.dFdNdN(j, phase, numberOfComponents, temperature, pressure);
    }

    public double dFCPAdN(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        for (int i = 0; i < this.numberOfAssociationSites; ++i) {
            xi += Math.log(this.xsite[i]);
        }
        return xi - ((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.calc_lngi(phase);
    }

    public double dFCPAdNdV(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = this.dFCPAdNdXidXdV(phase);
        double xi2 = -((PhaseCPAInterface)phase).getHcpatot() / 2.0 * this.calc_lngidV(phase);
        return xi + xi2;
    }

    public double dFCPAdNdT(PhaseInterface phase, int numberOfComponents, double temperature, double pressure) {
        double xi = 0.0;
        for (int i = 0; i < this.numberOfAssociationSites; ++i) {
            xi += (1.0 / this.xsite[i] - 0.5) * this.xsitedT[i];
        }
        return xi;
    }

    public double calc_lngidV(PhaseInterface phase) {
        return 2.0 * this.getBi() * 10.0 / ((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB())) - 2.0 * this.getBi() * (10.0 * phase.getTotalVolume() - phase.getB()) * (32.0 * Math.pow(phase.getTotalVolume(), 2.0) - 12.0 * phase.getTotalVolume() * phase.getB() + Math.pow(phase.getB(), 2.0)) / Math.pow((8.0 * phase.getTotalVolume() - phase.getB()) * (4.0 * phase.getTotalVolume() - phase.getB()), 2.0);
    }

    @Override
    public double dFCPAdVdXi(int site, PhaseInterface phase) {
        return 1.0 / (2.0 * phase.getTotalVolume()) * (1.0 - phase.getTotalVolume() * ((PhaseCPAInterface)phase).getGcpav()) * this.getNumberOfMolesInPhase();
    }

    @Override
    public double dFCPAdNdXi(int site, PhaseInterface phase) {
        double xi = 1.0 / this.xsite[site];
        return xi + this.getNumberOfMolesInPhase() / 2.0 * this.calc_lngi(phase);
    }

    @Override
    public double dFCPAdXidXj(int sitei, int sitej, int compj, PhaseInterface phase) {
        return 0.0;
    }

    @Override
    public double dFCPAdXi(int site, PhaseInterface phase) {
        return 0.0;
    }

    public double dFCPAdNdXidXdV(PhaseInterface phase) {
        double temp = 0.0;
        for (int i = 0; i < this.numberOfAssociationSites; ++i) {
            temp += this.dFCPAdNdXi(i, phase) * this.getXsitedV()[i];
        }
        return temp;
    }

    public double calc_lngi(PhaseInterface phase) {
        return 0.475 / (1.0 - 0.475 * phase.getB() / phase.getTotalVolume()) * this.getBi() / phase.getTotalVolume();
    }

    @Override
    public double[] getXsite() {
        return this.xsite;
    }

    public void setXsite(double[] xsite) {
        this.xsite = xsite;
    }

    @Override
    public void setXsite(int i, double xsite) {
        this.xsite[i] = xsite;
    }

    @Override
    public double[] getXsitedV() {
        return this.xsitedV;
    }

    @Override
    public void setXsitedV(int i, double xsitedV) {
        this.xsitedV[i] = xsitedV;
    }

    @Override
    public double[] getXsiteOld() {
        return this.xsiteOld;
    }

    public void setXsiteOld(double[] xsiteOld) {
        this.xsiteOld = xsiteOld;
    }

    @Override
    public void setXsiteOld(int i, double xsiteOld) {
    }

    @Override
    public double[] getXsitedT() {
        return null;
    }

    @Override
    public double[] getXsitedTdT() {
        return null;
    }

    @Override
    public void setXsitedT(int i, double xsitedT) {
    }

    @Override
    public void setXsitedTdT(int i, double xsitedT) {
    }

    @Override
    public void setXsitedni(int xnumb, int compnumb, double val) {
        this.xsitedni[xnumb][compnumb] = val;
    }
}

