/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.characterization;

import java.io.Serializable;
import neqsim.thermo.characterization.TBPModelInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TBPfractionModel
implements Serializable {
    private static final long serialVersionUID = 1000L;
    String name = "";
    static Logger logger = LogManager.getLogger(TBPfractionModel.class);

    public TBPModelInterface getModel(String name) {
        this.name = name;
        if (name.equals("PedersenSRK")) {
            return new PedersenTBPModelSRK();
        }
        if (name.equals("PedersenSRKHeavyOil")) {
            logger.info("using SRK heavy oil TBp.................");
            return new PedersenTBPModelSRKHeavyOil();
        }
        if (name.equals("PedersenPR")) {
            return new PedersenTBPModelPR();
        }
        if (name.equals("PedersenPRHeavyOil")) {
            logger.info("using PR heavy oil TBp.................");
            return new PedersenTBPModelPRHeavyOil();
        }
        if (name.equals("RiaziDaubert")) {
            return new RiaziDaubert();
        }
        return new PedersenTBPModelSRK();
    }

    public class RiaziDaubert
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;

        public RiaziDaubert() {
            this.calcm = false;
        }

        @Override
        public double calcTC(double molarMass, double density2) {
            if (molarMass > 300.0) {
                return super.calcTC(molarMass, density2);
            }
            return 308.0 * Math.exp(-1.3478E-4 * molarMass - 0.61641 * density2 + 0.0 * molarMass * density2) * Math.pow(molarMass, 0.2998) * Math.pow(density2, 1.0555);
        }

        @Override
        public double calcPC(double molarMass, double density2) {
            if (molarMass > 300.0) {
                return super.calcPC(molarMass, density2);
            }
            return 3116.6112409999996 * Math.exp(-0.0018078 * molarMass + -0.3084 * density2 + 0.0 * molarMass * density2) * Math.pow(molarMass, -0.8063) * Math.pow(density2, 1.6015);
        }

        public double calcAcentricFactor2(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double TB = this.calcTB(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            return 0.42857142857142855 * Math.log10(PC / 1.01325) / (TC / TB - 1.0) - 1.0;
        }

        @Override
        public double calcTB(double molarMass, double density2) {
            return 0.5555555555555556 * (1928.3 - 169500.0 * Math.pow(molarMass, -0.03522) * Math.pow(density2, 3.266) * Math.exp(-0.004922 * molarMass - 4.7685 * density2 + 0.003462 * molarMass * density2));
        }

        @Override
        public double calcAcentricFactor(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double TB = this.calcTB(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            double TBR = TB / TC;
            double PBR = 1.01325 / PC;
            if (TBR < 0.8) {
                return (Math.log(PBR) - 5.92714 + 6.09649 / TBR + 1.28862 * Math.log(TBR) - 0.169347 * Math.pow(TBR, 6.0)) / (15.2518 - 15.6875 / TBR - 13.4721 * Math.log(TBR) + 0.43577 * Math.pow(TBR, 6.0));
            }
            double Kw = Math.pow(TB, 0.3333333333333333) / density2;
            return -7.904 + 0.1352 * Kw - 0.007465 * Kw * Kw + 8.359 * TBR + (1.408 - 0.01063 * Kw) / TBR;
        }
    }

    public class PedersenTBPModelPRHeavyOil
    extends PedersenTBPModelPR {
        private static final long serialVersionUID = 1000L;

        public PedersenTBPModelPRHeavyOil() {
            double[][] TBPfractionCoefHeavyOil2 = new double[][]{{913.222, 10.1134, 0.0454194, -13587.0, 0.0}, {1.28155, 1.26838, 167.106, -8101.64, 0.25}, {-0.23838, 0.0610147, 1.32349, -0.00652067, 0.0}};
            this.TBPfractionCoefOil = TBPfractionCoefHeavyOil2;
            this.TBPfractionCoefsHeavyOil = TBPfractionCoefHeavyOil2;
        }
    }

    public class PedersenTBPModelPR
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;

        public PedersenTBPModelPR() {
            double[][] TBPfractionCoefOil2 = new double[][]{{73.4043, 97.3562, 0.618744, -2059.32, 0.0}, {0.0728462, 2.18811, 163.91, -4043.23, 0.25}, {0.373765, 0.00549269, 0.0117934, -4.93049E-6, 0.0}};
            double[][] TBPfractionCoefHeavyOil2 = new double[][]{{913.222, 10.1134, 0.0454194, -13587.0, 0.0}, {1.28155, 1.26838, 167.106, -8101.64, 0.25}, {-0.23838, 0.0610147, 1.32349, -0.00652067, 0.0}};
            double[] TPBracketcoefs2 = new double[]{0.25969, 0.50033};
            this.TBPfractionCoefOil = TBPfractionCoefOil2;
            this.TBPfractionCoefsHeavyOil = TBPfractionCoefHeavyOil2;
            this.TPBracketcoefs = TPBracketcoefs2;
        }
    }

    public class PedersenTBPModelSRKHeavyOil
    extends PedersenTBPModelSRK {
        private static final long serialVersionUID = 1000L;
        double[][] TBPfractionCoefsHeavyOil;
        double[][] TBPfractionCoefOil;

        public PedersenTBPModelSRKHeavyOil() {
            this.TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
            this.TBPfractionCoefOil = this.TBPfractionCoefsHeavyOil;
            this.TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
            this.TBPfractionCoefOil = this.TBPfractionCoefsHeavyOil;
        }
    }

    public class PedersenTBPModelSRK
    extends TBPBaseModel {
        private static final long serialVersionUID = 1000L;
        double[][] TBPfractionCoefOil;
        double[][] TBPfractionCoefsHeavyOil;
        double[] TPBracketcoefs;
        double[][] TBPfractionCoefs;

        public PedersenTBPModelSRK() {
            this.TBPfractionCoefOil = new double[][]{{163.12, 86.052, 0.43475, -1877.4, 0.0}, {-0.13408, 2.5019, 208.46, -3987.2, 1.0}, {0.7431, 0.0048122, 0.0096707, -3.7184E-6, 0.0}};
            this.TBPfractionCoefsHeavyOil = new double[][]{{830.63, 17.5228, 0.0455911, -11348.4, 0.0}, {0.802988, 1.78396, 156.74, -6965.59, 0.25}, {-0.047268, 0.0602931, 1.21051, -0.00576676, 0.0}};
            this.TPBracketcoefs = new double[]{0.29441, 0.40768};
            this.TBPfractionCoefs = null;
        }

        @Override
        public double calcTC(double molarMass, double density2) {
            this.TBPfractionCoefs = molarMass < 1120.0 ? this.TBPfractionCoefOil : this.TBPfractionCoefsHeavyOil;
            return this.TBPfractionCoefs[0][0] * density2 + this.TBPfractionCoefs[0][1] * Math.log(molarMass) + this.TBPfractionCoefs[0][2] * molarMass + this.TBPfractionCoefs[0][3] / molarMass;
        }

        @Override
        public double calcPC(double molarMass, double density2) {
            this.TBPfractionCoefs = molarMass < 1120.0 ? this.TBPfractionCoefOil : this.TBPfractionCoefsHeavyOil;
            return 0.01325 + Math.exp(this.TBPfractionCoefs[1][0] + this.TBPfractionCoefs[1][1] * Math.pow(density2, this.TBPfractionCoefs[1][4]) + this.TBPfractionCoefs[1][2] / molarMass + this.TBPfractionCoefs[1][3] / Math.pow(molarMass, 2.0));
        }

        @Override
        public double calcm(double molarMass, double density2) {
            if (molarMass < 1120.0) {
                this.TBPfractionCoefs = this.TBPfractionCoefOil;
                return this.TBPfractionCoefs[2][0] + this.TBPfractionCoefs[2][1] * molarMass + this.TBPfractionCoefs[2][2] * density2 + this.TBPfractionCoefs[2][3] * Math.pow(molarMass, 2.0);
            }
            this.TBPfractionCoefs = this.TBPfractionCoefsHeavyOil;
            return this.TBPfractionCoefs[2][0] + this.TBPfractionCoefs[2][1] * Math.log(molarMass) + this.TBPfractionCoefs[2][2] * density2 + this.TBPfractionCoefs[2][3] * Math.sqrt(molarMass);
        }

        @Override
        public double calcTB(double molarMass, double density2) {
            if (molarMass < 90.0) {
                return 357.15;
            }
            if (molarMass < 107.0) {
                return 389.75;
            }
            if (molarMass < 121.0) {
                return 415.34999999999997;
            }
            if (molarMass < 134.0) {
                return 438.95;
            }
            if (molarMass < 147.0) {
                return 460.34999999999997;
            }
            if (molarMass < 161.0) {
                return 481.45;
            }
            return 97.58 * Math.pow(molarMass, 0.3323) * Math.pow(density2, 0.04609);
        }

        @Override
        public double calcRacketZ(SystemInterface thermoSystem, double molarMass, double density2) {
            double penelouxC = thermoSystem.getPhase(0).getMolarVolume() - molarMass / (density2 * 10.0);
            double TC = this.calcTC(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            return this.TPBracketcoefs[0] - penelouxC / (this.TPBracketcoefs[1] * 8.3144621 * TC / PC);
        }
    }

    public abstract class TBPBaseModel
    implements TBPModelInterface,
    Cloneable,
    Serializable {
        private static final long serialVersionUID = 1000L;
        protected boolean calcm = true;

        @Override
        public String getName() {
            return TBPfractionModel.this.name;
        }

        @Override
        public double calcTB(double molarMass, double density2) {
            return Math.pow(molarMass / 5.805E-5 * Math.pow(density2, 0.9371), 0.42059219380888285);
        }

        @Override
        public double calcWatsonCharacterizationFactor(double molarMass, double density2) {
            return Math.pow(1.8 * this.calcTB(molarMass, density2), 0.3333333333333333) / density2;
        }

        @Override
        public double calcAcentricFactorKeslerLee(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double TB = this.calcTB(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            double TBR = TB / TC;
            double PBR = 1.01325 / PC;
            if (TBR < 0.8) {
                return (Math.log(PBR) - 5.92714 + 6.09649 / TBR + 1.28862 * Math.log(TBR) - 0.169347 * Math.pow(TBR, 6.0)) / (15.2518 - 15.6875 / TBR - 13.4721 * Math.log(TBR) + 0.43577 * Math.pow(TBR, 6.0));
            }
            double Kw = Math.pow(TB, 0.3333333333333333) / density2;
            return -7.904 + 0.1352 * Kw - 0.007465 * Kw * Kw + 8.359 * TBR + (1.408 - 0.01063 * Kw) / TBR;
        }

        @Override
        public double calcAcentricFactor(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double TB = this.calcTB(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            return 0.42857142857142855 * Math.log10(PC / 1.01325) / (TC / TB - 1.0) - 1.0;
        }

        @Override
        public double calcCriticalVolume(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            double acs = this.calcAcentricFactor(molarMass, density2);
            double criticaVol = (0.2918 - 0.0928 * acs) * 8.314 * TC / PC * 10.0;
            if (criticaVol < 0.0) {
                criticaVol = 1.6544860000000001 * TC / PC * 10.0;
            }
            return criticaVol;
        }

        @Override
        public double calcParachorParameter(double molarMass, double density2) {
            return 59.3 + 2.34 * molarMass * 1000.0;
        }

        @Override
        public double calcCriticalViscosity(double molarMass, double density2) {
            double TC = this.calcTC(molarMass, density2);
            double PC = this.calcPC(molarMass, density2);
            return 7.9483 * Math.sqrt(molarMass) * Math.pow(PC, 0.6666666666666666) / Math.pow(TC, 0.16666666666666666) * 1.0E-7;
        }

        @Override
        public boolean isCalcm() {
            return this.calcm;
        }
    }
}

