/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemSrkCPAstatoil;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Fluid {
    static Logger logger = LogManager.getLogger(Fluid.class);
    static SystemInterface fluid = null;
    private static boolean hasWater = false;
    private static boolean autoSelectModel = false;
    private static String thermoModel = "srk";
    private static String thermoMixingRule = "classic";

    private static void setThermoModel() {
        fluid = thermoModel.equals("srk") ? new SystemSrkEos() : (thermoModel.equals("pr") ? new SystemPrEos() : (thermoModel.equals("cpa") ? new SystemSrkCPAstatoil() : new SystemSrkEos()));
    }

    private static void setMixingRule() {
        fluid.setMixingRule(Fluid.getThermoMixingRule());
    }

    public static SystemInterface create2(String[] componentNames) {
        double[] comp = new double[componentNames.length];
        for (int i = 0; i < componentNames.length; ++i) {
            comp[i] = 1.0;
        }
        return Fluid.create2(componentNames, comp, "mol/sec");
    }

    public static SystemInterface create2(String[] componentNames, double[] flowrate, String unit) {
        Fluid.setThermoModel();
        Fluid.createFluid(componentNames, flowrate, unit);
        if (Fluid.isHasWater()) {
            fluid.addComponent("water", 0.1);
        }
        fluid.createDatabase(true);
        Fluid.setMixingRule();
        if (Fluid.isHasWater()) {
            fluid.setMultiPhaseCheck(true);
        }
        if (Fluid.isAutoSelectModel()) {
            fluid = fluid.autoSelectModel();
        }
        fluid.init(0);
        return fluid;
    }

    public static SystemInterface create(String fluidType) {
        String[] compNames = null;
        double[] flowrate = null;
        Fluid.setThermoModel();
        if (fluidType.equals("water")) {
            compNames = new String[]{"water"};
            flowrate = new double[]{1.0};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        }
        if (fluidType.equals("dry gas")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane"};
            flowrate = new double[]{0.01, 0.02, 0.82, 0.11, 0.05, 0.01, 0.012};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("rich gas")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.82, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("air")) {
            compNames = new String[]{"nitrogen", "oxygen"};
            flowrate = new double[]{0.78, 0.22};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("combustion air")) {
            compNames = new String[]{"nitrogen", "oxygen", "CO2", "water"};
            flowrate = new double[]{0.78084, 0.20946, 0.033, 0.1};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("gas condensate")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.32, 0.05, 0.03, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50"};
            double[] charFlowrate = new double[]{0.1, 0.08, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.3, 0.36, 0.4};
            double[] density2 = new double[]{0.7, 0.81, 0.88, 0.92};
            Fluid.addCharacterized(charNames, charFlowrate, molarMass, density2);
        } else if (fluidType.equals("petrol")) {
            compNames = new String[]{"n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10", "nC11", "nC12"};
            flowrate = new double[]{0.1, 0.1, 0.1, 0.1, 0.3, 0.1, 0.1, 0.1};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("diesel")) {
            compNames = new String[]{"n-heptane", "n-octane", "n-nonane", "nC10", "nC11", "nC12", "nC13", "nC14"};
            flowrate = new double[]{0.1, 0.1, 0.1, 0.3, 0.1, 0.1, 0.1, 0.1};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else if (fluidType.equals("light oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane", "n-heptane", "n-octane", "n-nonane", "nC10"};
            flowrate = new double[]{0.01, 0.02, 0.52, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.3, 0.36, 0.4};
            double[] density3 = new double[]{0.7, 0.81, 0.88, 0.92};
            Fluid.addCharacterized(charNames, charFlowrate, molarMass, density3);
        } else if (fluidType.equals("black oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.02, 0.22, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density4 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            Fluid.addCharacterized(charNames, charFlowrate, molarMass, density4);
        } else if (fluidType.equals("black oil with water")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.02, 0.22, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.1, 0.1, 0.05, 0.01};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density5 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            Fluid.addCharacterized(charNames, charFlowrate, molarMass, density5);
            Fluid.setHasWater(true);
        } else if (fluidType.equals("heavy oil")) {
            compNames = new String[]{"nitrogen", "CO2", "methane", "ethane", "propane", "i-butane", "n-butane", "i-pentane", "n-pentane", "n-hexane"};
            flowrate = new double[]{0.01, 0.01, 0.12, 0.11, 0.05, 0.01, 0.012, 0.01, 0.01, 0.01};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
            String[] charNames = new String[]{"C10-C15", "C16-C19", "C20-C30", "C31-C50", "C51-C80"};
            double[] charFlowrate = new double[]{0.2, 0.2, 0.2, 0.1, 0.1};
            double[] molarMass = new double[]{0.2, 0.25, 0.3, 0.36, 0.4};
            double[] density6 = new double[]{0.7, 0.75, 0.81, 0.88, 0.92};
            Fluid.addCharacterized(charNames, charFlowrate, molarMass, density6);
        } else if (NeqSimDataBase.hasComponent(fluidType)) {
            compNames = new String[]{fluidType};
            flowrate = new double[]{1.0};
            Fluid.createFluid(compNames, flowrate, "mole/sec");
        } else {
            return null;
        }
        if (Fluid.isHasWater()) {
            fluid.addComponent("water", 0.1);
        }
        fluid.createDatabase(true);
        Fluid.setMixingRule();
        if (Fluid.isHasWater()) {
            fluid.setMultiPhaseCheck(true);
        }
        if (Fluid.isAutoSelectModel()) {
            fluid = fluid.autoSelectModel();
        }
        fluid.init(0);
        return fluid;
    }

    public static void addCharacterized(String[] charNames, double[] charFlowrate, double[] molarMass, double[] relativedensity) {
        if (charNames.length != charFlowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        for (int i = 0; i < charNames.length; ++i) {
            fluid.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
    }

    public static SystemInterface addOilFractions(String[] charNames, double[] charFlowrate, double[] molarMass, double[] relativedensity, boolean lastIsPlusFraction) {
        int i;
        if (charNames.length != charFlowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        for (i = 0; i < charNames.length - 1; ++i) {
            fluid.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
        i = charNames.length - 1;
        if (lastIsPlusFraction) {
            fluid.addPlusFraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        } else {
            fluid.addTBPfraction(charNames[i], charFlowrate[i], molarMass[i], relativedensity[i]);
        }
        fluid.createDatabase(true);
        if (lastIsPlusFraction) {
            fluid.getCharacterization().getLumpingModel().setNumberOfPseudoComponents(12);
            fluid.getCharacterization().setLumpingModel("PVTlumpingModel");
            fluid.getCharacterization().characterisePlusFraction();
        }
        Fluid.setMixingRule();
        fluid.setMultiPhaseCheck(true);
        fluid.init(0);
        return fluid;
    }

    public static SystemInterface createFluid(String[] componentNames, double[] flowrate, String unit) {
        if (componentNames.length != flowrate.length) {
            logger.error("component names and mole fractions need to be same length...");
        }
        for (int i = 0; i < componentNames.length; ++i) {
            fluid.addComponent(componentNames[i], flowrate[i], unit);
        }
        return fluid;
    }

    public static void addComponment(String name) {
        fluid.addComponent(name, 1.0);
        fluid.createDatabase(true);
        fluid.setMixingRule(2);
        if (Fluid.isHasWater()) {
            fluid.setMultiPhaseCheck(true);
        }
    }

    public static void main(String[] args) {
        Fluid.setHasWater(true);
        SystemInterface fluid = Fluid.create("petrol");
        fluid.display();
        SystemInterface fluid2 = Fluid.create("dry gas");
        fluid2.display();
        fluid2.getNumberOfComponents();
        SystemInterface fluid3 = Fluid.create("black oil with water");
        fluid3.display();
        fluid3.getNumberOfComponents();
    }

    public static boolean isHasWater() {
        return hasWater;
    }

    public static void setHasWater(boolean hasWater) {
        Fluid.hasWater = hasWater;
    }

    public static boolean isAutoSelectModel() {
        return autoSelectModel;
    }

    public static void setAutoSelectModel(boolean autoSelectModel) {
        Fluid.autoSelectModel = autoSelectModel;
    }

    public static String getThermoModel() {
        return thermoModel;
    }

    public static void setThermoModel(String thermoModel) {
        Fluid.thermoModel = thermoModel;
    }

    public static String getThermoMixingRule() {
        return thermoMixingRule;
    }

    public static void setThermoMixingRule(String thermoMixingRule) {
        Fluid.thermoMixingRule = thermoMixingRule;
    }
}

