/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasQuality;

import java.sql.ResultSet;
import neqsim.standards.gasQuality.Standard_ISO6976;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Standard_ISO6976_2016
extends Standard_ISO6976 {
    private static final long serialVersionUID = 1000L;
    double R = 8.3144621;
    double Zmix0 = 1.0;
    double Zmix15 = 1.0;
    double Zmix20 = 1.0;
    double Zmix60F = 1.0;
    double Zair0 = 0.999419;
    double Zair15 = 0.999595;
    double Zair60F = 999601.0;
    double Zair20 = 0.999645;
    double[] Z0;
    double[] Z15;
    double[] Z20;
    double[] Z60F;
    double[] bsqrt0;
    double[] bsqrt15;
    double[] bsqrt20;
    double[] bsqrt60F;
    double[] Hsup0;
    double[] Hsup15;
    double[] Hsup20;
    double[] Hsup25;
    double[] Hsup60F;
    double[] Hinf0;
    double[] Hinf15;
    double[] Hinf20;
    double[] Hinf25;
    double[] Hinf60F;
    double HsupIdeal0 = 0.0;
    double HsupIdeal15 = 0.0;
    double HsupIdeal20 = 0.0;
    double HsupIdeal25 = 0.0;
    double HsupIdeal60F = 0.0;
    double HinfIdeal0 = 0.0;
    double HinfIdeal15 = 0.0;
    double HinfIdeal20 = 0.0;
    double HinfIdeal25 = 0.0;
    double HinfIdeal60F = 0.0;
    static Logger logger = LogManager.getLogger(Standard_ISO6976_2016.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Standard_ISO6976_2016(SystemInterface thermoSystem) {
        super("Standard_ISO6976_2016", "Calculation of calorific values, density, relative density and Wobbe index from composition based on ISO6976 version 2016", thermoSystem);
        this.M = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.carbonNumber = new int[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Z20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.bsqrt20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup25 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hsup60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf0 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf15 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf20 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf25 = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        this.Hinf60F = new double[thermoSystem.getPhase(0).getNumberOfComponents()];
        try {
            NeqSimDataBase database = new NeqSimDataBase();
            ResultSet dataSet = null;
            for (int i = 0; i < thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
                try {
                    dataSet = database.getResultSet("SELECT * FROM iso6976constants2016 WHERE ComponentName='" + this.thermoSystem.getPhase(0).getComponent(i).getName() + "'");
                    dataSet.next();
                    this.M[i] = Double.parseDouble(dataSet.getString("MolarMass"));
                }
                catch (Exception e) {
                    try {
                        String compName = "inert";
                        String compType = this.thermoSystem.getPhase(0).getComponent(i).getComponentType();
                        if (compType.equals("HC") || compType.equals("TBP") || compType.equals("plus")) {
                            compName = "n-heptane";
                        } else if (compType.equals("alcohol") || compType.equals("glycol")) {
                            compName = "methanol";
                        }
                        dataSet.close();
                        dataSet = database.getResultSet("SELECT * FROM iso6976constants2016 WHERE ComponentName='" + compName + "'");
                        this.M[i] = this.thermoSystem.getPhase(0).getComponent(i).getMolarMass();
                        dataSet.next();
                    }
                    catch (Exception er) {
                        logger.error(er.toString());
                    }
                    this.componentsNotDefinedByStandard.add("this.thermoSystem.getPhase(0).getComponent(i).getComponentName()");
                    logger.info("added component not specified by ISO6976constants2016 " + this.thermoSystem.getPhase(0).getComponent(i).getComponentName());
                }
                finally {
                    dataSet.close();
                }
                this.carbonNumber[i] = Integer.parseInt(dataSet.getString("numberOfCarbon"));
                this.Z0[i] = Double.parseDouble(dataSet.getString("Z0"));
                this.Z15[i] = Double.parseDouble(dataSet.getString("Z15"));
                this.Z60F[i] = Double.parseDouble(dataSet.getString("Z60F"));
                this.Z20[i] = Double.parseDouble(dataSet.getString("Z20"));
                this.bsqrt0[i] = Double.parseDouble(dataSet.getString("srtb0"));
                this.bsqrt15[i] = Double.parseDouble(dataSet.getString("srtb15"));
                this.bsqrt60F[i] = Double.parseDouble(dataSet.getString("srtb60F"));
                this.bsqrt20[i] = Double.parseDouble(dataSet.getString("srtb20"));
                this.Hsup0[i] = Double.parseDouble(dataSet.getString("Hsupmolar0"));
                this.Hsup15[i] = Double.parseDouble(dataSet.getString("Hsupmolar15"));
                this.Hsup20[i] = Double.parseDouble(dataSet.getString("Hsupmolar20"));
                this.Hsup25[i] = Double.parseDouble(dataSet.getString("Hsupmolar25"));
                this.Hsup60F[i] = Double.parseDouble(dataSet.getString("Hsupmolar60F"));
                this.Hinf0[i] = Double.parseDouble(dataSet.getString("Hinfmolar0"));
                this.Hinf15[i] = Double.parseDouble(dataSet.getString("Hinfmolar15"));
                this.Hinf20[i] = Double.parseDouble(dataSet.getString("Hinfmolar20"));
                this.Hinf25[i] = Double.parseDouble(dataSet.getString("Hinfmolar25"));
                this.Hinf60F[i] = Double.parseDouble(dataSet.getString("Hinfmolar60F"));
            }
            dataSet.close();
            database.getConnection().close();
        }
        catch (Exception e) {
            String err = e.toString();
            logger.error(err);
        }
    }

    public Standard_ISO6976_2016(SystemInterface thermoSystem, double volumetricReferenceTemperaturedegC, double energyReferenceTemperaturedegC, String calculationType) {
        this(thermoSystem);
        this.referenceType = calculationType;
        this.volRefT = volumetricReferenceTemperaturedegC;
        this.energyRefT = energyReferenceTemperaturedegC;
    }

    @Override
    public void calculate() {
        this.Zmix0 = 1.0;
        this.Zmix15 = 1.0;
        this.Zmix60F = 1.0;
        this.Zmix20 = 1.0;
        double Zmixtemp0 = 0.0;
        double Zmixtemp15 = 0.0;
        double Zmixtemp60F = 0.0;
        double Zmixtemp20 = 0.0;
        this.Mmix = 0.0;
        this.relDensIdeal = 0.0;
        this.HsupIdeal0 = 0.0;
        this.HsupIdeal15 = 0.0;
        this.HsupIdeal20 = 0.0;
        this.HsupIdeal25 = 0.0;
        this.HsupIdeal60F = 0.0;
        this.HinfIdeal0 = 0.0;
        this.HinfIdeal15 = 0.0;
        this.HinfIdeal20 = 0.0;
        this.HinfIdeal25 = 0.0;
        this.HinfIdeal60F = 0.0;
        for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            this.Mmix += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.M[i];
            Zmixtemp0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt0[i];
            Zmixtemp15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt15[i];
            Zmixtemp60F += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt60F[i];
            Zmixtemp20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.bsqrt20[i];
            this.HsupIdeal0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup0[i];
            this.HsupIdeal15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup15[i];
            this.HsupIdeal20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup20[i];
            this.HsupIdeal25 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup25[i];
            this.HsupIdeal60F += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hsup60F[i];
            this.HinfIdeal0 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf0[i];
            this.HinfIdeal15 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf15[i];
            this.HinfIdeal20 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf20[i];
            this.HinfIdeal25 += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf25[i];
            this.HinfIdeal60F += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.Hinf60F[i];
            this.relDensIdeal += this.thermoSystem.getPhase(0).getComponent(i).getz() * this.M[i] / 28.96546;
        }
        this.Zmix0 -= Math.pow(Zmixtemp0, 2.0);
        this.Zmix15 -= Math.pow(Zmixtemp15, 2.0);
        this.Zmix60F -= Math.pow(Zmixtemp60F, 2.0);
        this.Zmix20 -= Math.pow(Zmixtemp20, 2.0);
        this.molRefm3 = this.volRefP * 100000.0 * 1.0 / (this.R * (this.getVolRefT() + 273.15) * this.getValue("CompressionFactor"));
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        if (returnParameter.equals("GCV")) {
            returnParameter = "SuperiorCalorificValue";
        }
        if (returnParameter.equals("LCV")) {
            returnParameter = "InferiorCalorificValue";
        }
        double returnValue = 0.0;
        if (this.getVolRefT() == 0.0) {
            returnValue = this.Zmix0;
        } else if (this.getVolRefT() == 15.0) {
            returnValue = this.Zmix15;
        } else if (this.getVolRefT() == 15.55) {
            returnValue = this.Zmix60F;
        } else if (this.getVolRefT() == 20.0) {
            returnValue = this.Zmix20;
        }
        if (returnParameter.equals("CompressionFactor")) {
            return returnValue;
        }
        if (returnParameter.equals("MolarMass")) {
            return this.Mmix;
        }
        double realCorrection = 1.0;
        realCorrection = this.getReferenceState().equals("ideal") ? 1.0 : returnValue;
        if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HsupIdeal0;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HsupIdeal15;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HsupIdeal20;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HsupIdeal25;
        } else if (returnParameter.equals("SuperiorCalorificValue") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HsupIdeal60F;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HinfIdeal0;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HinfIdeal15;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HinfIdeal20;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HinfIdeal25;
        } else if (returnParameter.equals("InferiorCalorificValue") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HinfIdeal60F;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HsupIdeal0;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HsupIdeal15;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HsupIdeal20;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HsupIdeal25;
        } else if (returnParameter.equals("SuperiorWobbeIndex") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HsupIdeal60F;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 0.0) {
            returnValue = this.HinfIdeal0;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 15.0) {
            returnValue = this.HinfIdeal15;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 20.0) {
            returnValue = this.HinfIdeal20;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 15.55) {
            returnValue = this.HinfIdeal60F;
        } else if (returnParameter.equals("InferiorWobbeIndex") && this.getEnergyRefT() == 25.0) {
            returnValue = this.HinfIdeal25;
        }
        if (returnUnit.equals("kWh")) {
            returnValue /= 3600.0;
        }
        double relativeDens = 0.0;
        if (this.getReferenceState().equals("ideal")) {
            relativeDens = this.relDensIdeal;
        } else if (this.getVolRefT() == 0.0) {
            relativeDens = this.relDensIdeal * this.Zair0 / this.Zmix0;
        } else if (this.getVolRefT() == 15.0) {
            relativeDens = this.relDensIdeal * this.Zair15 / this.Zmix15;
        } else if (this.getVolRefT() == 15.55) {
            relativeDens = this.relDensIdeal * this.Zair60F / this.Zmix60F;
        } else if (this.getVolRefT() == 20.0) {
            relativeDens = this.relDensIdeal * this.Zair20 / this.Zmix20;
        }
        if (returnParameter.equals("RelativeDensity")) {
            return relativeDens;
        }
        if (returnParameter.equals("InferiorWobbeIndex") || returnParameter.equals("SuperiorWobbeIndex")) {
            returnValue /= Math.sqrt(relativeDens);
        }
        if (returnParameter.equals("DensityIdeal")) {
            return this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) * this.Mmix / 1000.0;
        }
        if (returnParameter.equals("DensityReal")) {
            return this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) * this.Mmix / 1000.0 / realCorrection;
        }
        if (this.getReferenceType().equals("molar")) {
            return returnValue;
        }
        if (this.getReferenceType().equals("mass")) {
            return returnValue / (this.Mmix / 1000.0);
        }
        return returnValue * this.volRefP * 100000.0 / (this.R * (this.getVolRefT() + 273.15)) / realCorrection;
    }

    @Override
    public double getValue(String returnParameter) {
        return this.getValue(returnParameter, "");
    }

    @Override
    public String getUnit(String returnParameter) {
        if (returnParameter.equals("CompressionFactor")) {
            return "-";
        }
        return this.energyUnit;
    }
}

