/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasQuality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemInterface;

public class GasChromotograpyhBase
extends Standard {
    private static final long serialVersionUID = 1L;
    String componentName = "";
    String unit = "mol%";

    public GasChromotograpyhBase(SystemInterface thermoSystem, String component) {
        super("gas cromotography", "Gas composition", thermoSystem);
        this.componentName = component;
    }

    @Override
    public void calculate() {
        this.thermoSystem.init(0);
        this.thermoSystem.init(0);
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        this.unit = returnUnit;
        if (returnUnit.equals("mol%")) {
            return 100.0 * this.thermoSystem.getPhase(0).getComponent(this.componentName).getz();
        }
        if (returnUnit.equals("mg/m3")) {
            return this.thermoSystem.getPhase(0).getComponent(this.componentName).getz() * 1000000.0;
        }
        return this.thermoSystem.getPhase(0).getComponent(this.componentName).getz();
    }

    @Override
    public double getValue(String returnParameter) {
        return this.thermoSystem.getPhase(0).getComponent(this.componentName).getz();
    }

    @Override
    public String getUnit(String returnParameter) {
        return this.unit;
    }

    @Override
    public boolean isOnSpec() {
        return true;
    }
}

