/*
 * Decompiled with CFR 0.152.
 */
package neqsim.standards.gasQuality;

import neqsim.standards.Standard;
import neqsim.thermo.system.SystemGERGwaterEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Draft_ISO18453
extends Standard {
    private static final long serialVersionUID = 1L;
    String dewPointTemperatureUnit = "C";
    String pressureUnit = "bar";
    double dewPointTemperature = 273.0;
    double dewPointTemperatureSpec = -12.0;
    double specPressure = 70.0;
    double initTemperature = 273.15;
    SystemInterface thermoSystem;
    ThermodynamicOperations thermoOps;

    public Draft_ISO18453(SystemInterface thermoSystem) {
        super("Draft_ISO18453", "water dew point calculation method");
        if (thermoSystem.getModelName().equals("GERGwater")) {
            this.thermoSystem = thermoSystem;
        } else {
            this.thermoSystem = new SystemGERGwaterEos(this.initTemperature, this.specPressure);
            for (int i = 0; i < thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
                this.thermoSystem.addComponent(thermoSystem.getPhase(0).getComponent(i).getName(), thermoSystem.getPhase(0).getComponent(i).getNumberOfmoles());
            }
        }
        this.thermoSystem.setTemperature(273.15);
        this.thermoSystem.setPressure(1.0);
        this.thermoSystem.setMixingRule(8);
        thermoSystem.init(0);
        thermoSystem.init(1);
        this.thermoOps = new ThermodynamicOperations(this.thermoSystem);
    }

    @Override
    public void calculate() {
        this.thermoSystem.setTemperature(this.initTemperature);
        this.thermoSystem.setPressure(this.specPressure);
        try {
            this.thermoOps.waterDewPointTemperatureFlash();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dewPointTemperature = this.thermoSystem.getTemperature() - 273.15;
    }

    @Override
    public double getValue(String returnParameter, String returnUnit) {
        if (returnParameter.equals("dewPointTemperature")) {
            return this.dewPointTemperature;
        }
        return this.dewPointTemperature;
    }

    @Override
    public double getValue(String returnParameter) {
        if (returnParameter.equals("dewPointTemperature")) {
            return this.dewPointTemperature;
        }
        if (returnParameter.equals("pressure")) {
            return this.thermoSystem.getPressure();
        }
        return this.dewPointTemperature;
    }

    @Override
    public String getUnit(String returnParameter) {
        if (returnParameter.equals("dewPointTemperature")) {
            return this.dewPointTemperatureUnit;
        }
        if (returnParameter.equals("pressureUnit")) {
            return this.pressureUnit;
        }
        return this.dewPointTemperatureUnit;
    }

    @Override
    public boolean isOnSpec() {
        return this.dewPointTemperature < this.getSalesContract().getWaterDewPointTemperature();
    }
}

