/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.ThreePhaseSeparator;
import neqsim.processSimulation.util.monitor.Fluid;

public class SeparatorResponse {
    public String name;
    public Double gasLoadFactor;
    public Double massflow;
    public Fluid gasFluid;
    public Fluid liquidFluid;
    public Fluid oilFluid;
    public Fluid waterFluid;

    public SeparatorResponse() {
    }

    public SeparatorResponse(ThreePhaseSeparator inputSeparator) {
        this.name = inputSeparator.getName();
        this.massflow = inputSeparator.getFluid().getFlowRate("kg/hr");
        this.gasLoadFactor = inputSeparator.getGasLoadFactor();
        if (inputSeparator.getThermoSystem().hasPhaseType("aqueous")) {
            this.waterFluid = new Fluid(inputSeparator.getWaterOutStream().getFluid());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("oil")) {
            this.oilFluid = new Fluid(inputSeparator.getOilOutStream().getFluid());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("gas")) {
            this.gasFluid = new Fluid(inputSeparator.getGasOutStream().getFluid());
        }
    }

    public SeparatorResponse(Separator inputSeparator) {
        this.name = inputSeparator.getName();
        this.massflow = inputSeparator.getFluid().getFlowRate("kg/hr");
        this.gasLoadFactor = inputSeparator.getGasLoadFactor();
        if (inputSeparator.getThermoSystem().hasPhaseType("aqueous")) {
            this.waterFluid = new Fluid(inputSeparator.getThermoSystem().phaseToSystem("aqueous"));
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("oil")) {
            this.oilFluid = new Fluid(inputSeparator.getThermoSystem().phaseToSystem("oil"));
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("gas")) {
            this.gasFluid = new Fluid(inputSeparator.getGasOutStream().getFluid());
        }
        if (inputSeparator.getThermoSystem().hasPhaseType("oil") || inputSeparator.getThermoSystem().hasPhaseType("aqueous")) {
            this.liquidFluid = new Fluid(inputSeparator.getLiquidOutStream().getFluid());
        }
    }
}

