/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.util.monitor;

import neqsim.processSimulation.processEquipment.pump.Pump;

public class PumpResponse {
    public String name = "test";
    public Double suctionTemperature;
    public Double dischargeTemperature;
    public Double suctionPressure;
    public Double dischargePressure;
    public Double power;
    public Double suctionVolumeFlow;
    public Double internalVolumeFlow;
    public Double dischargeVolumeFlow;
    public Double molarMass;
    public Double suctionMassDensity;
    public Double dischargeMassDensity;
    public Double massflow;
    public Integer speed;

    public PumpResponse() {
    }

    public PumpResponse(Pump inputPump) {
        this.name = inputPump.getName();
        this.molarMass = inputPump.getInStream().getFluid().getMolarMass();
        this.suctionMassDensity = inputPump.getInStream().getFluid().getDensity("kg/m3");
        this.dischargeMassDensity = inputPump.getOutStream().getFluid().getDensity("kg/m3");
        this.massflow = inputPump.getInStream().getFluid().getFlowRate("kg/hr");
        this.suctionVolumeFlow = inputPump.getInStream().getFluid().getFlowRate("m3/hr");
        this.dischargeVolumeFlow = inputPump.getOutStream().getFluid().getFlowRate("m3/hr");
        this.suctionPressure = inputPump.getInStream().getPressure("bara");
        this.suctionTemperature = inputPump.getInStream().getTemperature("C");
        this.dischargeTemperature = inputPump.getOutStream().getTemperature("C");
        this.dischargePressure = inputPump.getOutStream().getPressure("bara");
        this.power = inputPump.getPower("W");
    }
}

