/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processSystem.processModules;

import neqsim.processSimulation.processEquipment.heatExchanger.Cooler;
import neqsim.processSimulation.processEquipment.heatExchanger.Heater;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.ThreePhaseSeparator;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.valve.ThrottlingValve;
import neqsim.processSimulation.processSystem.ProcessModuleBaseClass;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class WellFluidModule
extends ProcessModuleBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface feedStream = null;
    protected StreamInterface outStream = null;
    Cooler oilCooler;
    double secondstagePressure = 15.0;
    double inletPressure = 55.0;
    double gasfactor = 0.1;
    double thirdstagePressure = 1.01325;
    double separationTemperature = 288.15;
    double exitGasScrubberTemperature = 303.15;
    double firstStageCompressorAfterCoolerTemperature = 303.15;
    double exportOilTemperature = 303.15;

    public WellFluidModule(String name) {
        super(name);
    }

    @Override
    public void addInputStream(String streamName, StreamInterface stream) {
        if (streamName.equals("feed stream")) {
            this.feedStream = stream;
        }
    }

    @Override
    public StreamInterface getOutputStream(String streamName) {
        if (!this.isInitializedStreams) {
            this.initializeStreams();
        }
        return this.outStream;
    }

    @Override
    public void run() {
        if (!this.isInitializedModule) {
            this.initializeModule();
        }
        this.getOperations().run();
        double volGas = ((Mixer)this.getOperations().getUnit("gas mixer")).getOutStream().getThermoSystem().getVolume();
        double volOil = ((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().getThermoSystem().getVolume();
        double GOR2 = volGas / volOil;
        System.out.println("GOR " + GOR2);
        this.outStream = ((Mixer)this.getOperations().getUnit("well mixer")).getOutStream();
        Stream gasStream = (Stream)((Heater)this.getOperations().getUnit("gas heater")).getOutStream().clone();
        gasStream.getThermoSystem().setPressure(this.inletPressure);
        Stream oilStream = (Stream)((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().clone();
        oilStream.getThermoSystem().setPressure(this.inletPressure);
        ((Separator)this.getOperations().getUnit("Inlet separator")).addStream(gasStream);
        ((Separator)this.getOperations().getUnit("Inlet separator")).addStream(oilStream);
        this.getOperations().run();
        volGas = ((Mixer)this.getOperations().getUnit("gas mixer")).getOutStream().getThermoSystem().getVolume();
        volOil = ((ThreePhaseSeparator)this.getOperations().getUnit("3rd stage Separator")).getOilOutStream().getThermoSystem().getVolume();
        GOR2 = volGas / volOil;
        System.out.println("GOR " + GOR2);
        this.outStream = ((Mixer)this.getOperations().getUnit("well mixer")).getOutStream();
    }

    @Override
    public void initializeModule() {
        this.isInitializedModule = true;
        this.inletPressure = this.feedStream.getPressure();
        Separator inletSeparator = new Separator("Inlet separator", this.feedStream);
        Heater liquidOutHeater = new Heater("oil/water heater", inletSeparator.getLiquidOutStream());
        liquidOutHeater.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator firstStageSeparator = new ThreePhaseSeparator("1st stage separator", liquidOutHeater.getOutStream());
        ThrottlingValve valve1 = new ThrottlingValve("1stTo2ndStageOilValve", firstStageSeparator.getOilOutStream());
        valve1.setOutletPressure(this.secondstagePressure);
        Heater liquidOutHeater2 = new Heater("oil/water heater2", valve1.getOutStream());
        liquidOutHeater2.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator secondStageSeparator = new ThreePhaseSeparator("2nd stage Separator", liquidOutHeater2.getOutStream());
        ThrottlingValve thirdStageValve = new ThrottlingValve("2-3stageOilValve", secondStageSeparator.getLiquidOutStream());
        thirdStageValve.setOutletPressure(this.thirdstagePressure);
        Heater liquidOutHeater3 = new Heater("oil/water heater3", thirdStageValve.getOutStream());
        liquidOutHeater3.setOutTemperature(this.separationTemperature);
        ThreePhaseSeparator thirdStageSeparator = new ThreePhaseSeparator("3rd stage Separator", liquidOutHeater3.getOutStream());
        Mixer gasMixer = new Mixer("gas mixer");
        gasMixer.addStream(inletSeparator.getGasOutStream());
        gasMixer.addStream(firstStageSeparator.getGasOutStream());
        gasMixer.addStream(secondStageSeparator.getGasOutStream());
        gasMixer.addStream(thirdStageSeparator.getGasOutStream());
        Heater gasHeater = new Heater("gas heater", gasMixer.getOutStream());
        gasHeater.setOutTemperature(this.separationTemperature);
        Mixer wellStreamMixer = new Mixer("well mixer");
        wellStreamMixer.addStream(thirdStageSeparator.getOilOutStream());
        wellStreamMixer.addStream(gasHeater.getOutStream());
        this.getOperations().add(inletSeparator);
        this.getOperations().add(liquidOutHeater);
        this.getOperations().add(firstStageSeparator);
        this.getOperations().add(valve1);
        this.getOperations().add(liquidOutHeater2);
        this.getOperations().add(secondStageSeparator);
        this.getOperations().add(thirdStageValve);
        this.getOperations().add(liquidOutHeater3);
        this.getOperations().add(thirdStageSeparator);
        this.getOperations().add(gasMixer);
        this.getOperations().add(gasHeater);
        this.getOperations().add(wellStreamMixer);
    }

    @Override
    public void initializeStreams() {
        this.isInitializedStreams = true;
    }

    @Override
    public void runTransient(double dt) {
        this.getOperations().runTransient(dt);
    }

    @Override
    public void calcDesign() {
    }

    @Override
    public void setDesign() {
    }

    @Override
    public void setSpecification(String specificationName, double value) {
        if (specificationName.equals("Second stage pressure")) {
            this.secondstagePressure = value;
        }
        if (specificationName.equals("separation temperature")) {
            this.separationTemperature = value;
        }
        if (specificationName.equals("Third stage pressure")) {
            this.thirdstagePressure = value;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(323.15, 65.0);
        testSystem.addComponent("methane", 195.0);
        testSystem.addComponent("nC10", 6.0);
        testSystem.addComponent("water", 12.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        testSystem.init(0);
        testSystem.init(3);
        double a = testSystem.getTotalNumberOfMoles();
        Stream wellStream = new Stream("Well stream", testSystem);
        WellFluidModule separationModule = new WellFluidModule("separationModule");
        separationModule.addInputStream("feed stream", wellStream);
        separationModule.setSpecification("Second stage pressure", 15.0);
        separationModule.setSpecification("separation temperature", 288.15);
        separationModule.setSpecification("Third stage pressure", 1.01325);
        ProcessSystem operations = new ProcessSystem();
        operations.add(wellStream);
        operations.add(separationModule);
        operations.run();
    }
}

