/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class StreamSaturatorUtil
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    StreamInterface inletStream;
    StreamInterface outStream;
    SystemInterface thermoSystem;
    private boolean multiPhase = true;

    @Deprecated
    public StreamSaturatorUtil(StreamInterface inletStream) {
        this("StreamSaturatorUtil", inletStream);
    }

    public StreamSaturatorUtil(String name, StreamInterface inStream) {
        super(name);
        this.setInletStream(inStream);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = new Stream("outStream", this.thermoSystem);
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void run() {
        boolean changeBack = false;
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        if (this.multiPhase && !this.thermoSystem.doMultiPhaseCheck()) {
            this.thermoSystem.setMultiPhaseCheck(true);
            changeBack = true;
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.saturateWithWater();
        this.thermoSystem.init(3);
        if (changeBack) {
            this.thermoSystem.setMultiPhaseCheck(false);
        }
        this.outStream.setThermoSystem(this.thermoSystem);
    }

    public boolean isMultiPhase() {
        return this.multiPhase;
    }

    public void setMultiPhase(boolean multiPhase) {
        this.multiPhase = multiPhase;
    }
}

