/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.AnnularFlow;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.DropletFlowNode;
import neqsim.fluidMechanics.flowNode.twoPhaseNode.twoPhasePipeFlowNode.StratifiedFlowNode;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;

public class NeqSimUnit
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    StreamInterface inletStream;
    StreamInterface outStream;
    SystemInterface thermoSystem;
    private String equipment = "pipeline";
    String flowPattern = "stratified";
    private double length = 1.0;
    public int numberOfNodes = 100;
    private double ID = 0.5;
    private double outerTemperature = 283.15;
    public double interfacialArea = 0.0;

    public NeqSimUnit(StreamInterface inletStream, String equipment, String flowPattern) {
        super("NeqSimUnit");
        this.flowPattern = flowPattern;
        this.setEquipment(equipment);
        this.setInletStream(inletStream);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.outStream = new Stream("outStream", this.thermoSystem);
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        if (this.equipment.equals("pipeline") && this.flowPattern.equals("stratified")) {
            this.runStratified();
        } else if (this.equipment.equals("pipeline") && this.flowPattern.equals("annular")) {
            this.runAnnular();
        } else if (this.equipment.equals("pipeline") && this.flowPattern.equals("droplet")) {
            this.runDroplet();
        } else {
            this.runStratified();
        }
    }

    public void runDroplet() {
        PipeData pipe1 = new PipeData(this.getID(), 2.5E-4);
        DropletFlowNode test2 = new DropletFlowNode(this.thermoSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.setLengthOfNode(this.getLength() / ((double)this.numberOfNodes * 1.0));
        test2.getGeometry().getSurroundingEnvironment().setTemperature(this.getOuterTemperature());
        test2.getFluidBoundary().setHeatTransferCalc(false);
        test2.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test2.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        this.interfacialArea = 0.0;
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.interfacialArea = this.getInterfacialArea() + test2.getInterphaseContactArea();
            length += test2.getLengthOfNode();
            test2.initFlowCalc();
            test2.calcFluxes();
            if (i > 1 && i % 1 == 0) {
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test2.getGeometry().getInnerWallTemperature();
            }
            test2.update();
        }
        this.outStream.setThermoSystem(test2.getBulkSystem());
    }

    public void runStratified() {
        PipeData pipe1 = new PipeData(this.getID(), 2.5E-4);
        StratifiedFlowNode test2 = new StratifiedFlowNode(this.thermoSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.setLengthOfNode(this.getLength() / ((double)this.numberOfNodes * 1.0));
        test2.getGeometry().getSurroundingEnvironment().setTemperature(this.getOuterTemperature());
        test2.getFluidBoundary().setHeatTransferCalc(false);
        test2.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test2.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        this.interfacialArea = 0.0;
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.interfacialArea = this.getInterfacialArea() + test2.getInterphaseContactArea();
            length += test2.getLengthOfNode();
            test2.initFlowCalc();
            test2.calcFluxes();
            if (i > 1 && i % 1 == 0) {
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test2.getGeometry().getInnerWallTemperature();
            }
            test2.update();
        }
        this.outStream.setThermoSystem(test2.getBulkSystem());
    }

    public void runAnnular() {
        PipeData pipe1 = new PipeData(this.getID(), 2.5E-4);
        AnnularFlow test2 = new AnnularFlow(this.thermoSystem, pipe1);
        test2.setInterphaseModelType(1);
        test2.setLengthOfNode(this.getLength() / ((double)this.numberOfNodes * 1.0));
        test2.getGeometry().getSurroundingEnvironment().setTemperature(this.getOuterTemperature());
        test2.getFluidBoundary().setHeatTransferCalc(false);
        test2.getFluidBoundary().setMassTransferCalc(true);
        double length = 0.0;
        test2.initFlowCalc();
        double[][] temperatures2 = new double[3][1000];
        int k = 0;
        this.interfacialArea = 0.0;
        for (int i = 0; i < this.numberOfNodes; ++i) {
            this.interfacialArea = this.getInterfacialArea() + test2.getInterphaseContactArea();
            length += test2.getLengthOfNode();
            test2.initFlowCalc();
            test2.calcFluxes();
            if (i > 1 && i % 1 == 0) {
                temperatures2[0][++k] = length;
                temperatures2[1][k] = test2.getGeometry().getInnerWallTemperature();
            }
            test2.update();
        }
        this.outStream.setThermoSystem(test2.getBulkSystem());
    }

    public double getLength() {
        return this.length;
    }

    public void setLength(double length) {
        this.length = length;
    }

    public double getID() {
        return this.ID;
    }

    public void setID(double iD) {
        this.ID = iD;
    }

    public double getOuterTemperature() {
        return this.outerTemperature;
    }

    public void setOuterTemperature(double outerTemperature) {
        this.outerTemperature = outerTemperature;
    }

    public String getEquipment() {
        return this.equipment;
    }

    public void setEquipment(String equipment) {
        this.equipment = equipment;
    }

    public double getInterfacialArea() {
        return this.interfacialArea;
    }

    public int getNumberOfNodes() {
        return this.numberOfNodes;
    }

    public void setNumberOfNodes(int numberOfNodes) {
        this.numberOfNodes = numberOfNodes;
    }
}

