/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.util;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Adjuster
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    ProcessEquipmentInterface adjustedEquipment = null;
    ProcessEquipmentInterface targetEquipment = null;
    String adjustedVarialble = "";
    String targetVariable = "";
    String targetPhase = "";
    String targetComponent = "";
    double targetValue = 0.0;
    String targetUnit = "";
    private double tolerance = 1.0E-6;
    double inputValue = 0.0;
    double oldInputValue = 0.0;
    private double error = 1000000.0;
    private double oldError = 1000000.0;
    int iterations = 0;
    private boolean activateWhenLess = false;
    static Logger logger = LogManager.getLogger(Adjuster.class);

    @Deprecated
    public Adjuster() {
        this("Adjuster");
    }

    public Adjuster(String name) {
        super(name);
    }

    public void setAdjustedVariable(ProcessEquipmentInterface adjustedEquipment, String adjstedVariable) {
        this.adjustedEquipment = adjustedEquipment;
        this.adjustedVarialble = adjstedVariable;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
    }

    public void setTargetVariable(ProcessEquipmentInterface targetEquipment, String targetVariable, double targetValue, String targetUnit, String targetPhase, String targetComponent) {
        this.targetEquipment = targetEquipment;
        this.targetVariable = targetVariable;
        this.targetValue = targetValue;
        this.targetUnit = targetUnit;
        this.targetPhase = targetPhase;
        this.targetComponent = targetComponent;
    }

    @Override
    public void runTransient(double dt) {
        this.run();
    }

    @Override
    public void run() {
        double deviation;
        this.oldError = this.error;
        this.inputValue = this.adjustedVarialble.equals("mass flow") ? ((Stream)this.adjustedEquipment).getThermoSystem().getFlowRate("kg/hr") : ((Stream)this.adjustedEquipment).getThermoSystem().getNumberOfMoles();
        double targetValueCurrent = 0.0;
        targetValueCurrent = this.targetVariable.equals("mass fraction") && !this.targetPhase.equals("") && !this.targetComponent.equals("") ? ((Stream)this.targetEquipment).getThermoSystem().getPhase(this.targetPhase).getWtFrac(this.targetComponent) : (this.targetVariable.equals("gasVolumeFlow") ? ((Stream)this.targetEquipment).getThermoSystem().getFlowRate(this.targetUnit) : (this.targetVariable.equals("pressure") ? ((Stream)this.targetEquipment).getThermoSystem().getPressure(this.targetUnit) : ((Stream)this.targetEquipment).getThermoSystem().getVolume(this.targetUnit)));
        if (this.activateWhenLess && targetValueCurrent > this.targetValue) {
            this.error = 0.0;
            this.activateWhenLess = true;
            return;
        }
        ++this.iterations;
        this.error = deviation = this.targetValue - targetValueCurrent;
        logger.info("adjuster deviation " + deviation + " inputValue " + this.inputValue);
        if (this.iterations < 2) {
            if (this.adjustedVarialble.equals("mass flow")) {
                ((Stream)this.adjustedEquipment).getThermoSystem().setTotalFlowRate(this.inputValue + deviation, "kg/hr");
            } else {
                ((Stream)this.adjustedEquipment).getThermoSystem().setTotalFlowRate(this.inputValue + deviation, "mol/sec");
            }
        } else {
            double derivate = (this.error - this.oldError) / (this.inputValue - this.oldInputValue);
            double newVal = this.error / derivate;
            if (this.adjustedVarialble.equals("mass flow")) {
                ((Stream)this.adjustedEquipment).getThermoSystem().setTotalFlowRate(this.inputValue - newVal, "kg/hr");
            } else {
                ((Stream)this.adjustedEquipment).getThermoSystem().setTotalFlowRate(this.inputValue - newVal, "mol/sec");
            }
        }
        this.oldInputValue = this.inputValue;
    }

    @Override
    public boolean solved() {
        return Math.abs(this.error) < this.tolerance;
    }

    @Override
    public void displayResult() {
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    public double getError() {
        return this.error;
    }

    public void setError(double error) {
        this.error = error;
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(298.15, 20.0);
        testSystem.addComponent("methane", 1000.0);
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        Stream stream_1 = new Stream("Stream1", testSystem);
        Adjuster adjuster1 = new Adjuster();
        adjuster1.setAdjustedVariable(stream_1, "molarFlow");
        adjuster1.setTargetVariable(stream_1, "gasVolumeFlow", 10.0, "MSm3/day", "");
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(adjuster1);
        operations.run();
    }

    public boolean isActivateWhenLess() {
        return this.activateWhenLess;
    }

    public void setActivateWhenLess(boolean activateWhenLess) {
        this.activateWhenLess = activateWhenLess;
    }
}

