/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.subsea;

import java.util.ArrayList;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.pipeline.AdiabaticTwoPhasePipe;
import neqsim.processSimulation.processEquipment.reservoir.SimpleReservoir;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processEquipment.subsea.SimpleFlowLine;
import neqsim.processSimulation.processEquipment.util.Adjuster;
import neqsim.processSimulation.processEquipment.valve.ThrottlingValve;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;

public class SubseaWell
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface inStream;
    private StreamInterface outStream;
    public double height = 1000.0;
    public double length = 1200.0;
    AdiabaticTwoPhasePipe pipeline;

    public SubseaWell(StreamInterface instream) {
        super("SubseaWell");
        this.inStream = instream;
        this.setOutStream(instream.clone());
        this.pipeline = new AdiabaticTwoPhasePipe("pipeline", instream);
    }

    public AdiabaticTwoPhasePipe getPipeline() {
        return this.pipeline;
    }

    @Override
    public void run() {
        this.pipeline.run();
        this.getOutStream().setFluid(this.pipeline.getOutStream().getFluid());
    }

    public static void main(String[] args) {
        SystemSrkEos testSystem = new SystemSrkEos(373.15, 250.0);
        testSystem.addComponent("nitrogen", 0.1);
        testSystem.addComponent("methane", 70.0);
        testSystem.addComponent("ethane", 1.0);
        testSystem.addComponent("propane", 1.0);
        testSystem.addComponent("i-butane", 1.0);
        testSystem.addComponent("n-butane", 1.0);
        testSystem.addComponent("n-hexane", 0.1);
        testSystem.addComponent("n-heptane", 0.1);
        testSystem.addComponent("n-nonane", 1.0);
        testSystem.addComponent("nC10", 1.0);
        testSystem.addComponent("nC12", 3.0);
        testSystem.addComponent("nC15", 13.0);
        testSystem.addComponent("nC20", 13.0);
        testSystem.addComponent("water", 11.0);
        testSystem.setMixingRule(2);
        testSystem.setMultiPhaseCheck(true);
        SimpleReservoir reservoirOps = new SimpleReservoir("Well 1 reservoir");
        reservoirOps.setReservoirFluid(testSystem, 5.0E7, 5.52E8, 1.0E7);
        StreamInterface producedOilStream = reservoirOps.addOilProducer("oilproducer_1");
        producedOilStream.setFlowRate(5.04E7, "kg/day");
        reservoirOps.run();
        System.out.println("water volume" + reservoirOps.getReservoirFluid().getPhase("aqueous").getVolume("m3") / 1000000.0);
        System.out.println("oil production  total" + reservoirOps.getOilProductionTotal("Sm3") + " Sm3");
        System.out.println("total produced  " + reservoirOps.getProductionTotal("MSm3 oe") + " MSm3 oe");
        SubseaWell well1 = new SubseaWell(reservoirOps.getOilProducer("oilproducer_1").getStream());
        well1.getPipeline().setDiameter(0.3);
        well1.getPipeline().setLength(5500.0);
        well1.getPipeline().setInletElevation(-1000.0);
        well1.getPipeline().setOutletElevation(-100.0);
        ThrottlingValve subseaChoke = new ThrottlingValve("subseaChoke", well1.getOutStream());
        subseaChoke.setOutletPressure(90.0);
        subseaChoke.setAcceptNegativeDP(false);
        SimpleFlowLine flowLine = new SimpleFlowLine(subseaChoke.getOutStream());
        flowLine.getPipeline().setDiameter(0.4);
        flowLine.getPipeline().setLength(2000.0);
        flowLine.getPipeline().setInletElevation(-100.0);
        ThrottlingValve topsideChoke = new ThrottlingValve("topsideChoke", flowLine.getOutStream());
        topsideChoke.setOutletPressure(50.0, "bara");
        topsideChoke.setAcceptNegativeDP(false);
        Adjuster adjust = new Adjuster("adjust");
        adjust.setActivateWhenLess(true);
        adjust.setTargetVariable(flowLine.getOutStream(), "pressure", 70.0, "bara");
        adjust.setAdjustedVariable(producedOilStream, "flow rate");
        ProcessSystem ops = new ProcessSystem();
        ops.add(well1);
        ops.add(subseaChoke);
        ops.add(flowLine);
        ops.add(topsideChoke);
        ops.add(adjust);
        ArrayList<double[]> res = new ArrayList<double[]>();
        reservoirOps.runTransient(86400.0);
        ops.run();
        res.add(new double[]{reservoirOps.getTime(), producedOilStream.getFluid().getFlowRate("kg/hr"), reservoirOps.getOilProductionTotal("MSm3 oe")});
        System.out.println("subsea choke DP " + subseaChoke.getDeltaPressure("bara"));
        System.out.println("topside  choke DP " + topsideChoke.getDeltaPressure("bara"));
        System.out.println("oil production " + producedOilStream.getFluid().getFlowRate("kg/hr"));
        ProcessSystem GasOilProcess = ProcessSystem.open("c:/temp/offshorePro.neqsim");
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setThermoSystem(topsideChoke.getOutStream().getFluid());
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setPressure(70.0, "bara");
        ((StreamInterface)GasOilProcess.getUnit("well stream")).setTemperature(65.0, "C");
        GasOilProcess.run();
        System.out.println("power " + GasOilProcess.getPower("MW"));
        for (int i = 0; i < res.size(); ++i) {
            System.out.println("time " + ((double[])res.get(i))[0] + " oil production " + ((double[])res.get(i))[1] + " total production MSm3 oe " + ((double[])res.get(i))[2]);
        }
    }

    public StreamInterface getOutStream() {
        return this.outStream;
    }

    public void setOutStream(StreamInterface outStream) {
        this.outStream = outStream;
    }
}

