/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.splitter.SplitterInterface;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Splitter
extends ProcessEquipmentBaseClass
implements SplitterInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];

    public Splitter() {
        super("Splitter");
    }

    @Deprecated
    public Splitter(StreamInterface inletStream) {
        this();
        this.setInletStream(inletStream);
    }

    public Splitter(String name) {
        super(name);
    }

    public Splitter(String name, StreamInterface inStream) {
        this(name);
        this.setInletStream(inStream);
    }

    public Splitter(String name, StreamInterface inletStream, int i) {
        this(name);
        this.setSplitNumber(i);
        this.setInletStream(inletStream);
    }

    @Override
    public void setSplitNumber(int i) {
        this.splitNumber = i;
        this.splitFactor = new double[this.splitNumber];
        this.splitFactor[0] = 1.0;
    }

    public void setSplitFactors(double[] splitFact) {
        int i;
        double sum = 0.0;
        for (i = 0; i < splitFact.length; ++i) {
            if (splitFact[i] < 0.0) {
                splitFact[i] = 0.0;
            }
            sum += splitFact[i];
        }
        this.splitFactor = new double[splitFact.length];
        for (i = 0; i < splitFact.length; ++i) {
            this.splitFactor[i] = splitFact[i] / sum;
        }
        this.splitNumber = splitFact.length;
        this.setInletStream(this.inletStream);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.splitStream = new Stream[this.splitNumber];
        try {
            for (int i = 0; i < this.splitNumber; ++i) {
                this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run() {
        for (int i = 0; i < this.splitNumber; ++i) {
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            for (int j = 0; j < this.inletStream.getThermoSystem().getPhase(0).getNumberOfComponents(); ++j) {
                int index = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getComponentNumber();
                double moles = this.inletStream.getThermoSystem().getPhase(0).getComponent(j).getNumberOfmoles();
                this.splitStream[i].getThermoSystem().addComponent(index, moles * this.splitFactor[i] - moles);
            }
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
        }
    }

    @Override
    public void displayResult() {
    }

    @Override
    public void runTransient(double dt) {
    }
}

