/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.splitter;

import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class ComponentSplitter
extends ProcessEquipmentBaseClass {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    StreamInterface inletStream;
    StreamInterface[] splitStream;
    protected int splitNumber = 1;
    double[] splitFactor = new double[1];

    public ComponentSplitter() {
        super("Component Splitter");
    }

    public ComponentSplitter(String name) {
        super(name);
    }

    public ComponentSplitter(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public void setSplitFactors(double[] factors) {
        this.splitFactor = factors;
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.splitStream = new Stream[2];
        try {
            for (int i = 0; i < this.splitStream.length; ++i) {
                this.splitStream[i] = new Stream("Split Stream", inletStream.getThermoSystem().clone());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public StreamInterface getSplitStream(int i) {
        return this.splitStream[i];
    }

    @Override
    public void run() {
        for (int i = 0; i < 2; ++i) {
            int k;
            this.thermoSystem = this.inletStream.getThermoSystem().clone();
            this.thermoSystem.setEmptyFluid();
            if (i == 0) {
                for (k = 0; k < this.thermoSystem.getNumberOfComponents(); ++k) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * this.splitFactor[k]);
                }
            } else {
                for (k = 0; k < this.thermoSystem.getNumberOfComponents(); ++k) {
                    this.thermoSystem.addComponent(k, this.inletStream.getThermoSystem().getComponent(k).getNumberOfmoles() * (1.0 - this.splitFactor[k]));
                }
            }
            this.thermoSystem.init(0);
            this.splitStream[i].setThermoSystem(this.thermoSystem);
            ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.splitStream[i].getThermoSystem());
            thermoOps.TPflash();
        }
    }

    @Override
    public void displayResult() {
    }

    @Override
    public void runTransient(double dt) {
        this.run();
    }
}

