/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import java.util.ArrayList;
import java.util.Objects;
import neqsim.processSimulation.mechanicalDesign.separator.SeparatorMechanicalDesign;
import neqsim.processSimulation.processEquipment.ProcessEquipmentBaseClass;
import neqsim.processSimulation.processEquipment.mixer.Mixer;
import neqsim.processSimulation.processEquipment.separator.SeparatorInterface;
import neqsim.processSimulation.processEquipment.separator.sectionType.ManwaySection;
import neqsim.processSimulation.processEquipment.separator.sectionType.MeshSection;
import neqsim.processSimulation.processEquipment.separator.sectionType.NozzleSection;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;
import neqsim.processSimulation.processEquipment.separator.sectionType.ValveSection;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class Separator
extends ProcessEquipmentBaseClass
implements SeparatorInterface {
    private static final long serialVersionUID = 1000L;
    SystemInterface thermoSystem;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    SystemInterface thermoSystem2;
    private String orientation = "horizontal";
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    private double pressureDrop = 0.0;
    private double internalDiameter = 1.0;
    public int numberOfInputStreams = 0;
    Mixer inletStreamMixer = new Mixer("Separator Inlet Stream Mixer");
    private double efficiency = 1.0;
    private double liquidCarryoverFraction = 0.0;
    private double gasCarryunderFraction = 0.0;
    private double separatorLength = 5.0;
    double liquidVolume = 1.0;
    double gasVolume = 18.0;
    private double liquidLevel = this.liquidVolume / (this.liquidVolume + this.gasVolume);
    private double designLiquidLevelFraction = 0.8;
    ArrayList<SeparatorSection> separatorSection = new ArrayList();

    @Deprecated
    public Separator() {
        super("Separator");
    }

    @Deprecated
    public Separator(StreamInterface inletStream) {
        this("Separator", inletStream);
    }

    public Separator(String name) {
        super(name);
    }

    public Separator(String name, StreamInterface inletStream) {
        this(name);
        this.setInletStream(inletStream);
    }

    public SeparatorMechanicalDesign gMechanicalDesign() {
        return new SeparatorMechanicalDesign(this);
    }

    public void setInletStream(StreamInterface inletStream) {
        this.inletStreamMixer.addStream(inletStream);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[0]);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(this.thermoSystem.getPhases()[1]);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    public void addStream(StreamInterface newStream) {
        if (this.numberOfInputStreams == 0) {
            this.setInletStream(newStream);
        } else {
            this.inletStreamMixer.addStream(newStream);
        }
        ++this.numberOfInputStreams;
    }

    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public SystemInterface getThermoSystem() {
        return this.thermoSystem;
    }

    @Override
    public void run() {
        this.inletStreamMixer.run();
        this.thermoSystem2 = this.inletStreamMixer.getOutStream().getThermoSystem().clone();
        this.thermoSystem2.setPressure(this.thermoSystem2.getPressure() - this.pressureDrop);
        if (this.thermoSystem2.hasPhaseType("gas")) {
            this.gasOutStream.setThermoSystemFromPhase(this.thermoSystem2, "gas");
            this.gasOutStream.getFluid().init(2);
        } else {
            this.gasOutStream.setThermoSystem(this.thermoSystem2.getEmptySystemClone());
        }
        if (this.thermoSystem2.hasPhaseType("aqueous") || this.thermoSystem2.hasPhaseType("oil")) {
            this.liquidOutStream.setThermoSystemFromPhase(this.thermoSystem2, "liquid");
            this.liquidOutStream.getFluid().init(2);
        } else {
            this.liquidOutStream.setThermoSystem(this.thermoSystem2.getEmptySystemClone());
        }
        if (this.thermoSystem2.hasPhaseType("gas")) {
            this.gasOutStream.run();
        }
        if (this.thermoSystem2.hasPhaseType("aqueous") || this.thermoSystem2.hasPhaseType("oil")) {
            this.liquidOutStream.run();
        }
        try {
            this.thermoSystem = this.thermoSystem2.clone();
            this.thermoSystem.setTotalNumberOfMoles(1.0E-10);
            this.thermoSystem.init(1);
            double totalliquidVolume = 0.0;
            for (int j = 0; j < this.thermoSystem.getNumberOfPhases(); ++j) {
                double relFact = this.gasVolume / (this.thermoSystem2.getPhase(j).getVolume() * 1.0E-5);
                if (j >= 1) {
                    relFact = this.liquidVolume / (this.thermoSystem2.getPhase(j).getVolume() * 1.0E-5);
                    totalliquidVolume += this.liquidVolume / this.thermoSystem2.getPhase(j).getMolarVolume();
                }
                for (int i = 0; i < this.thermoSystem.getPhase(j).getNumberOfComponents(); ++i) {
                    this.thermoSystem.addComponent(this.thermoSystem.getPhase(j).getComponent(i).getComponentNumber(), relFact * this.thermoSystem2.getPhase(j).getComponent(i).getNumberOfMolesInPhase(), j);
                }
            }
            if (this.thermoSystem.hasPhaseType("gas")) {
                this.thermoSystem.setBeta(this.gasVolume / this.thermoSystem2.getPhase(0).getMolarVolume() / (this.gasVolume / this.thermoSystem2.getPhase(0).getMolarVolume() + totalliquidVolume));
            }
            this.thermoSystem.initBeta();
            this.thermoSystem.init(3);
            this.liquidLevel = this.thermoSystem.getPhase(1).getVolume() * 1.0E-5 / (this.liquidVolume + this.gasVolume);
            this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
            this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.thermoSystem = this.thermoSystem2;
    }

    @Override
    public void displayResult() {
        this.thermoSystem.display();
    }

    @Override
    public String[][] getResultTable() {
        return this.thermoSystem.getResultTable();
    }

    @Override
    public void runTransient(double dt) {
        this.inletStreamMixer.run();
        this.thermoSystem.init(3);
        this.gasOutStream.getThermoSystem().init(3);
        this.liquidOutStream.getThermoSystem().init(3);
        double volume1 = this.thermoSystem.getVolume();
        double deltaEnergy = this.inletStreamMixer.getOutStream().getThermoSystem().getEnthalpy() - this.gasOutStream.getThermoSystem().getEnthalpy() - this.liquidOutStream.getThermoSystem().getEnthalpy();
        double newEnergy = this.thermoSystem.getInternalEnergy() + dt * deltaEnergy;
        for (int i = 0; i < this.thermoSystem.getPhase(0).getNumberOfComponents(); ++i) {
            double dn = this.inletStreamMixer.getOutStream().getThermoSystem().getPhase(0).getComponent(i).getNumberOfMolesInPhase() + this.inletStreamMixer.getOutStream().getThermoSystem().getPhase(1).getComponent(i).getNumberOfMolesInPhase() - this.gasOutStream.getThermoSystem().getPhase(0).getComponent(i).getNumberOfMolesInPhase() - this.liquidOutStream.getThermoSystem().getPhase(0).getComponent(i).getNumberOfMolesInPhase();
            this.thermoSystem.addComponent(this.inletStreamMixer.getOutStream().getThermoSystem().getPhase(0).getComponent(i).getComponentNumber(), dn * dt);
        }
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.VUflash(volume1, newEnergy);
        this.setTempPres(this.thermoSystem.getTemperature(), this.thermoSystem.getPressure());
        this.liquidLevel = this.thermoSystem.getPhase(1).getVolume() * 1.0E-5 / (this.liquidVolume + this.gasVolume);
        this.liquidVolume = this.getLiquidLevel() * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
        this.gasVolume = (1.0 - this.getLiquidLevel()) * 3.14 / 4.0 * this.getInternalDiameter() * this.getInternalDiameter() * this.getSeparatorLength();
    }

    public void setTempPres(double temp, double pres) {
        this.gasOutStream.getThermoSystem().setTemperature(temp);
        this.liquidOutStream.getThermoSystem().setTemperature(temp);
        this.inletStreamMixer.setPressure(pres);
        this.gasOutStream.getThermoSystem().setPressure(pres);
        this.liquidOutStream.getThermoSystem().setPressure(pres);
        this.inletStreamMixer.run();
        this.gasOutStream.run();
        this.liquidOutStream.run();
    }

    public double getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(double efficiency) {
        this.efficiency = efficiency;
    }

    public double getLiquidCarryoverFraction() {
        return this.liquidCarryoverFraction;
    }

    public void setLiquidCarryoverFraction(double liquidCarryoverFraction) {
        this.liquidCarryoverFraction = liquidCarryoverFraction;
    }

    public double getGasCarryunderFraction() {
        return this.gasCarryunderFraction;
    }

    public void setGasCarryunderFraction(double gasCarryunderFraction) {
        this.gasCarryunderFraction = gasCarryunderFraction;
    }

    public double getLiquidLevel() {
        return this.liquidLevel;
    }

    public double getPressureDrop() {
        return this.pressureDrop;
    }

    public void setPressureDrop(double pressureDrop) {
        this.pressureDrop = pressureDrop;
    }

    public double getInternalDiameter() {
        return this.internalDiameter;
    }

    @Override
    public void setInternalDiameter(double diameter) {
        this.internalDiameter = diameter;
    }

    public double getGasSuperficialVelocity() {
        return this.thermoSystem.getPhase(0).getTotalVolume() / 100000.0 / (3.14159265 * this.getInternalDiameter() * this.getInternalDiameter() / 4.0);
    }

    public double getGasLoadFactor() {
        this.thermoSystem.initPhysicalProperties();
        double term1 = (this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getGasLoadFactor(int phaseNumber) {
        double gasAreaFraction = 1.0;
        if (this.orientation.equals("horizontal")) {
            gasAreaFraction = 1.0 - this.liquidVolume / (this.liquidVolume + this.gasVolume);
        }
        this.thermoSystem.initPhysicalProperties();
        double term1 = 1.0 / gasAreaFraction * (this.thermoSystem.getPhase(2).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getDeRatedGasLoadFactor() {
        this.thermoSystem.initPhysicalProperties();
        double derating = 1.0;
        double surfaceTension = this.thermoSystem.getInterphaseProperties().getSurfaceTension(0, 1);
        if (surfaceTension < 0.01) {
            derating = 1.0 - 0.5 * (0.01 - surfaceTension) / 0.01;
        }
        System.out.println("derating " + derating);
        double term1 = (this.thermoSystem.getPhase(1).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return derating * this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public double getDeRatedGasLoadFactor(int phase) {
        this.thermoSystem.initPhysicalProperties();
        double derating = 1.0;
        double surfaceTension = this.thermoSystem.getInterphaseProperties().getSurfaceTension(phase - 1, phase);
        if (surfaceTension < 0.01) {
            derating = 1.0 - 0.5 * (0.01 - surfaceTension) / 0.01;
        }
        System.out.println("derating " + derating);
        double term1 = (this.thermoSystem.getPhase(phase).getPhysicalProperties().getDensity() - this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity()) / this.thermoSystem.getPhase(0).getPhysicalProperties().getDensity();
        return derating * this.getGasSuperficialVelocity() * Math.sqrt(1.0 / term1);
    }

    public String getOrientation() {
        return this.orientation;
    }

    public void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    public double getSeparatorLength() {
        return this.separatorLength;
    }

    public void setSeparatorLength(double separatorLength) {
        this.separatorLength = separatorLength;
    }

    public SeparatorSection getSeparatorSection(int i) {
        return this.separatorSection.get(i);
    }

    public SeparatorSection getSeparatorSection(String name) {
        for (SeparatorSection sec : this.separatorSection) {
            if (!sec.getName().equals(name)) continue;
            return sec;
        }
        System.out.println("no section with name: " + name + " found.....");
        return null;
    }

    public ArrayList<SeparatorSection> getSeparatorSections() {
        return this.separatorSection;
    }

    public void addSeparatorSection(String name, String type) {
        if (type.equals("vane")) {
            this.separatorSection.add(new SeparatorSection(name, type, this));
        } else if (type.equals("meshpad")) {
            this.separatorSection.add(new MeshSection(name, type, this));
        } else if (type.equals("manway")) {
            this.separatorSection.add(new ManwaySection(name, type, this));
        } else if (type.equals("valve")) {
            this.separatorSection.add(new ValveSection(name, type, this));
        } else if (type.equals("nozzle")) {
            this.separatorSection.add(new NozzleSection(name, type, this));
        } else {
            this.separatorSection.add(new SeparatorSection(name, type, this));
        }
    }

    public double getDesignLiquidLevelFraction() {
        return this.designLiquidLevelFraction;
    }

    public void setDesignLiquidLevelFraction(double designLiquidLevelFraction) {
        this.designLiquidLevelFraction = designLiquidLevelFraction;
    }

    @Override
    public double getPressure() {
        return this.getThermoSystem().getPressure();
    }

    @Override
    public double getEntropyProduction(String unit) {
        double entrop = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            entrop += this.inletStreamMixer.getStream(i).getFluid().getEntropy(unit);
        }
        if (this.thermoSystem.hasPhaseType("aqueous") || this.thermoSystem.hasPhaseType("oil")) {
            try {
                this.getLiquidOutStream().getThermoSystem().init(3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.thermoSystem.hasPhaseType("gas")) {
            this.getGasOutStream().getThermoSystem().init(3);
        }
        return this.getLiquidOutStream().getThermoSystem().getEntropy(unit) + this.getGasOutStream().getThermoSystem().getEntropy(unit) - entrop;
    }

    @Override
    public double getMassBalance(String unit) {
        double flow = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            flow += this.inletStreamMixer.getStream(i).getFluid().getFlowRate(unit);
        }
        this.getLiquidOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getLiquidOutStream().getThermoSystem().getFlowRate(unit) + this.getGasOutStream().getThermoSystem().getFlowRate(unit) - flow;
    }

    @Override
    public double getExergyChange(String unit, double surroundingTemperature) {
        double exergy = 0.0;
        for (int i = 0; i < this.numberOfInputStreams; ++i) {
            this.inletStreamMixer.getStream(i).getFluid().init(3);
            exergy += this.inletStreamMixer.getStream(i).getFluid().getExergy(surroundingTemperature, unit);
        }
        this.getLiquidOutStream().getThermoSystem().init(3);
        this.getGasOutStream().getThermoSystem().init(3);
        return this.getLiquidOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) + this.getGasOutStream().getThermoSystem().getExergy(surroundingTemperature, unit) - exergy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.designLiquidLevelFraction, this.efficiency, this.gasCarryunderFraction, this.gasOutStream, this.gasSystem, this.gasVolume, this.inletStreamMixer, this.internalDiameter, this.liquidCarryoverFraction, this.liquidLevel, this.liquidOutStream, this.liquidSystem, this.liquidVolume, this.numberOfInputStreams, this.orientation, this.pressureDrop, this.separatorLength, this.separatorSection, this.thermoSystem, this.thermoSystem2, this.thermoSystemCloned, this.waterSystem);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Separator other = (Separator)obj;
        return Double.doubleToLongBits(this.designLiquidLevelFraction) == Double.doubleToLongBits(other.designLiquidLevelFraction) && Double.doubleToLongBits(this.efficiency) == Double.doubleToLongBits(other.efficiency) && Double.doubleToLongBits(this.gasCarryunderFraction) == Double.doubleToLongBits(other.gasCarryunderFraction) && Objects.equals(this.gasOutStream, other.gasOutStream) && Objects.equals(this.gasSystem, other.gasSystem) && Double.doubleToLongBits(this.gasVolume) == Double.doubleToLongBits(other.gasVolume) && Objects.equals(this.inletStreamMixer, other.inletStreamMixer) && Double.doubleToLongBits(this.internalDiameter) == Double.doubleToLongBits(other.internalDiameter) && Double.doubleToLongBits(this.liquidCarryoverFraction) == Double.doubleToLongBits(other.liquidCarryoverFraction) && Double.doubleToLongBits(this.liquidLevel) == Double.doubleToLongBits(other.liquidLevel) && Objects.equals(this.liquidOutStream, other.liquidOutStream) && Objects.equals(this.liquidSystem, other.liquidSystem) && Double.doubleToLongBits(this.liquidVolume) == Double.doubleToLongBits(other.liquidVolume) && this.numberOfInputStreams == other.numberOfInputStreams && Objects.equals(this.orientation, other.orientation) && Double.doubleToLongBits(this.pressureDrop) == Double.doubleToLongBits(other.pressureDrop) && Double.doubleToLongBits(this.separatorLength) == Double.doubleToLongBits(other.separatorLength) && Objects.equals(this.separatorSection, other.separatorSection) && Objects.equals(this.thermoSystem, other.thermoSystem) && Objects.equals(this.thermoSystem2, other.thermoSystem2) && Objects.equals(this.thermoSystemCloned, other.thermoSystemCloned) && Objects.equals(this.waterSystem, other.waterSystem);
    }
}

