/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.separator;

import neqsim.processSimulation.mechanicalDesign.separator.GasScrubberMechanicalDesign;
import neqsim.processSimulation.processEquipment.separator.Separator;
import neqsim.processSimulation.processEquipment.separator.sectionType.SeparatorSection;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class GasScrubberSimple
extends Separator {
    private static final long serialVersionUID = 1000L;
    SystemInterface gasSystem;
    SystemInterface waterSystem;
    SystemInterface liquidSystem;
    SystemInterface thermoSystemCloned;
    StreamInterface inletStream;
    StreamInterface gasOutStream;
    StreamInterface liquidOutStream;
    String name = new String();

    @Deprecated
    public GasScrubberSimple() {
        this("GasScrubberSimple");
    }

    @Deprecated
    public GasScrubberSimple(StreamInterface inletStream) {
        this("GasScrubberSimple", inletStream);
    }

    public GasScrubberSimple(String name) {
        super(name);
        this.setOrientation("vertical");
    }

    public GasScrubberSimple(String name, StreamInterface inletStream) {
        super(name, inletStream);
        this.setOrientation("vertical");
    }

    @Override
    public GasScrubberMechanicalDesign getMechanicalDesign() {
        return new GasScrubberMechanicalDesign(this);
    }

    @Override
    public void setInletStream(StreamInterface inletStream) {
        this.inletStream = inletStream;
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.gasSystem = this.thermoSystem.phaseToSystem(0);
        this.gasOutStream = new Stream("gasOutStream", this.gasSystem);
        this.thermoSystem = inletStream.getThermoSystem().clone();
        this.liquidSystem = this.thermoSystem.phaseToSystem(1);
        this.liquidOutStream = new Stream("liquidOutStream", this.liquidSystem);
    }

    @Override
    public StreamInterface getLiquidOutStream() {
        return this.liquidOutStream;
    }

    @Override
    public StreamInterface getGasOutStream() {
        return this.gasOutStream;
    }

    @Override
    public StreamInterface getGas() {
        return this.getGasOutStream();
    }

    @Override
    public StreamInterface getLiquid() {
        return this.getLiquidOutStream();
    }

    @Override
    public void run() {
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(this.thermoSystem);
        thermoOps.TPflash();
        if (this.separatorSection.size() > 0) {
            this.calcLiquidCarryoverFraction();
            this.thermoSystem.addLiquidToGas(this.getLiquidCarryoverFraction());
        }
        this.gasSystem = this.thermoSystem.phaseToSystem(0);
        this.gasSystem.setNumberOfPhases(1);
        this.gasOutStream.setThermoSystem(this.gasSystem);
        this.thermoSystem = this.inletStream.getThermoSystem().clone();
        if (this.separatorSection.size() > 0) {
            this.thermoSystem.addGasToLiquid(this.getGasCarryunderFraction());
            this.liquidSystem = this.thermoSystem.phaseToSystem(1);
        }
        this.liquidSystem.setNumberOfPhases(1);
        this.liquidOutStream.setThermoSystem(this.liquidSystem);
    }

    public double calcLiquidCarryoverFraction() {
        double Ktot = 1.0;
        for (int i = 0; i < this.separatorSection.size(); ++i) {
            Ktot *= 1.0 - ((SeparatorSection)this.separatorSection.get(i)).getEfficiency();
        }
        System.out.println("Ktot " + (1.0 - Ktot));
        double area = this.getInternalDiameter() * this.getInternalDiameter() / 4.0 * 3.14;
        double gasVel = this.thermoSystem.getTotalNumberOfMoles() * this.thermoSystem.getMolarVolume() / 100000.0 / area;
        this.setLiquidCarryoverFraction(Ktot);
        return gasVel;
    }

    @Override
    public void runTransient(double dt) {
    }
}

