/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.processEquipment.pipeline;

import neqsim.processSimulation.processEquipment.pipeline.AdiabaticPipe;
import neqsim.processSimulation.processEquipment.pipeline.Fittings;
import neqsim.processSimulation.processEquipment.stream.Stream;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class IncompressiblePipeFlow
extends AdiabaticPipe {
    private static final long serialVersionUID = 1000L;
    Fittings fittings = new Fittings();
    private double totalEqLenth = 0.0;
    double momentum = 0.0;

    @Deprecated
    public IncompressiblePipeFlow() {
        super("IncompressiblePipeFlow");
    }

    @Deprecated
    public IncompressiblePipeFlow(StreamInterface inStream) {
        this("IncompressiblePipeFlow", inStream);
    }

    public IncompressiblePipeFlow(String name) {
        super(name);
    }

    public IncompressiblePipeFlow(String name, StreamInterface inStream) {
        super(name, inStream);
    }

    public void addFittingFromDatabase(String name) {
        this.fittings.add(name);
    }

    public void addFitting(String name, double LdivD) {
        this.fittings.add(name, LdivD);
    }

    @Override
    public double calcPressureOut() {
        this.setTotalEqLenth(this.length);
        for (int i = 0; i < this.fittings.fittingList.size(); ++i) {
            this.setTotalEqLenth(this.getTotalEqLenth() + this.fittings.getFittingsList().get(i).getLtoD());
        }
        double area = 0.785 * Math.pow(this.insideDiameter, 2.0);
        double velocity = 1.0 / this.system.getPhase(0).getPhysicalProperties().getDensity() / (this.system.getPhase(0).getNumberOfMolesInPhase() * (this.system.getPhase(0).getMolarVolume() / 100000.0)) / area;
        this.momentum = this.system.getPhase(0).getPhysicalProperties().getDensity() * velocity * velocity;
        double reynoldsNumber = velocity * this.insideDiameter / this.system.getPhase(0).getPhysicalProperties().getKinematicViscosity();
        double frictionFactor = this.calcWallFrictionFactor(reynoldsNumber);
        double dp = -this.momentum * frictionFactor * this.getTotalEqLenth() / (2.0 * this.insideDiameter);
        System.out.println("outpres " + (this.system.getPressure() * 100000.0 + (dp += (this.getInletElevation() - this.getOutletElevation()) * this.system.getPhase(0).getPhysicalProperties().getDensity() * 9.80665)) / 100000.0 + " dp " + dp + " friction fact" + frictionFactor + " velocity " + velocity + " reynolds number " + reynoldsNumber + " equivalentLength " + this.getTotalEqLenth());
        return (this.system.getPressure() * 100000.0 + dp) / 100000.0;
    }

    @Override
    public void run() {
        this.system = this.inStream.getThermoSystem().clone();
        if (this.setTemperature) {
            this.system.setTemperature(this.temperatureOut);
        }
        this.system.init(3);
        this.system.initPhysicalProperties();
        this.calcPressureOut();
        this.system.setPressure(this.calcPressureOut());
        ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
        testOps.TPflash();
        this.outStream.setThermoSystem(this.system);
    }

    public static void main(String[] name) {
        SystemSrkEos testSystem = new SystemSrkEos(298.15, 10.0);
        testSystem.addComponent("water", 100000.0, "kg/hr");
        testSystem.createDatabase(true);
        testSystem.setMixingRule(2);
        testSystem.initPhysicalProperties();
        Stream stream_1 = new Stream("Stream1", testSystem);
        IncompressiblePipeFlow pipe = new IncompressiblePipeFlow(stream_1);
        pipe.setLength(1000.0);
        pipe.setDiameter(0.25);
        pipe.setPipeWallRoughness(2.0E-5);
        pipe.addFittingFromDatabase("Standard elbow (R=1.5D), 90deg");
        IncompressiblePipeFlow pipe2 = new IncompressiblePipeFlow(pipe.getOutStream());
        pipe2.setLength(1000.0);
        pipe2.setDiameter(0.25);
        pipe2.setPipeWallRoughness(2.0E-5);
        pipe2.setInletElevation(10.0);
        pipe2.setOutletElevation(0.0);
        ProcessSystem operations = new ProcessSystem();
        operations.add(stream_1);
        operations.add(pipe);
        operations.add(pipe2);
        operations.run();
        pipe.displayResult();
    }

    public double getTotalEqLenth() {
        return this.totalEqLenth;
    }

    public void setTotalEqLenth(double totalEqLenth) {
        this.totalEqLenth = totalEqLenth;
    }
}

