/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class pHProbe
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    protected StreamInterface stream = null;
    protected SystemInterface reactiveThermoSystem;
    protected ThermodynamicOperations thermoOps;
    private double alkanility = 0.0;

    public pHProbe() {
    }

    public pHProbe(StreamInterface stream) {
        this.stream = stream;
    }

    public void run() {
        if (this.stream != null) {
            if (this.stream.getFluid().hasPhaseType("aqueous")) {
                this.reactiveThermoSystem = this.stream.getFluid().clone();
                this.reactiveThermoSystem = this.reactiveThermoSystem.setModel("Electrolyte-CPA-EOS-statoil");
                if (this.getAlkanility() > 1.0E-10) {
                    double waterkg = this.reactiveThermoSystem.getComponent("water").getTotalFlowRate("kg/sec");
                    this.reactiveThermoSystem.addComponent("Na+", waterkg * this.getAlkanility() / 1000.0);
                    this.reactiveThermoSystem.addComponent("OH-", waterkg * this.getAlkanility() / 1000.0);
                }
                if (!this.reactiveThermoSystem.isChemicalSystem()) {
                    this.reactiveThermoSystem.chemicalReactionInit();
                    this.reactiveThermoSystem.setMixingRule(10);
                    this.reactiveThermoSystem.setMultiPhaseCheck(false);
                }
                this.thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
                this.thermoOps.TPflash();
            } else {
                return;
            }
        }
    }

    @Override
    public void displayResult() {
        System.out.println("measured temperature " + this.stream.getTemperature());
    }

    @Override
    public double getMeasuredValue() {
        if (this.stream != null) {
            if (this.stream.getFluid().hasPhaseType("aqueous")) {
                this.reactiveThermoSystem = this.stream.getFluid().clone();
                this.reactiveThermoSystem = this.reactiveThermoSystem.setModel("Electrolyte-CPA-EOS-statoil");
                if (this.getAlkanility() > 1.0E-10) {
                    double waterkg = this.reactiveThermoSystem.getComponent("water").getTotalFlowRate("kg/sec");
                    this.reactiveThermoSystem.addComponent("Na+", waterkg * this.getAlkanility() / 1000.0);
                    this.reactiveThermoSystem.addComponent("OH-", waterkg * this.getAlkanility() / 1000.0);
                }
                if (!this.reactiveThermoSystem.isChemicalSystem()) {
                    this.reactiveThermoSystem.chemicalReactionInit();
                    this.reactiveThermoSystem.setMixingRule(10);
                    this.reactiveThermoSystem.setMultiPhaseCheck(false);
                }
                this.thermoOps = new ThermodynamicOperations(this.reactiveThermoSystem);
                this.thermoOps.TPflash();
                return this.reactiveThermoSystem.getPhase(this.reactiveThermoSystem.getPhaseNumberOfPhase("aqueous")).getpH();
            }
            System.out.println("no aqueous phase for pH analyser");
            return 7.0;
        }
        System.out.println("no stream connected to pH analyser");
        return Double.NaN;
    }

    public double getAlkanility() {
        return this.alkanility;
    }

    public void setAlkanility(double alkanility) {
        this.alkanility = alkanility;
    }
}

