/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.measurementDevice;

import neqsim.PVTsimulation.simulation.SaturationPressure;
import neqsim.processSimulation.measurementDevice.MeasurementDeviceBaseClass;
import neqsim.processSimulation.processEquipment.stream.StreamInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class CricondenbarAnalyser
extends MeasurementDeviceBaseClass {
    private static final long serialVersionUID = 1000L;
    protected int streamNumber = 0;
    protected static int numberOfStreams = 0;
    protected StreamInterface stream = null;

    public CricondenbarAnalyser() {
    }

    public CricondenbarAnalyser(StreamInterface stream) {
        this.stream = stream;
        this.streamNumber = ++numberOfStreams;
        this.unit = "K";
        this.setConditionAnalysisMaxDeviation(1.0);
    }

    @Override
    public void displayResult() {
    }

    @Override
    public double getMeasuredValue() {
        return this.getMeasuredValue(this.unit);
    }

    @Override
    public double getMeasuredValue(String unit) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        tempFluid.removeComponent("water");
        ThermodynamicOperations thermoOps = new ThermodynamicOperations(tempFluid);
        try {
            thermoOps.setRunAsThread(true);
            thermoOps.calcPTphaseEnvelope(false, 1.0);
            thermoOps.waitAndCheckForFinishedCalculation(15000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thermoOps.get("cricondenbar")[1];
    }

    public double getMeasuredValue2(String unit, double temp) {
        SystemInterface tempFluid = this.stream.getThermoSystem().clone();
        tempFluid.setTemperature(temp, "C");
        tempFluid.setPressure(10.0, "bara");
        if (tempFluid.getPhase(0).hasComponent("water")) {
            tempFluid.removeComponent("water");
        }
        SaturationPressure thermoOps = new SaturationPressure(tempFluid);
        try {
            thermoOps.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return thermoOps.getSaturationPressure();
    }
}

