/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.costEstimation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import neqsim.processSimulation.processEquipment.ProcessEquipmentInterface;
import neqsim.processSimulation.processSystem.ProcessSystem;

public class CostEstimateBaseClass
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private ProcessSystem processSystem;
    private double CAPEXperWeight = 1000.0;

    public CostEstimateBaseClass(ProcessSystem process) {
        this.processSystem = process;
    }

    public CostEstimateBaseClass(ProcessSystem process, double costFactor) {
        this(process);
        this.CAPEXperWeight = costFactor;
    }

    public double getWeightBasedCAPEXEstimate() {
        return this.processSystem.getSystemMechanicalDesign().getTotalWeight() * this.CAPEXperWeight;
    }

    public double getCAPEXestimate() {
        double cost = 0.0;
        ArrayList<String> names = this.processSystem.getAllUnitNames();
        for (int i = 0; i < names.size(); ++i) {
            try {
                if ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i)) == null) continue;
                cost += ((ProcessEquipmentInterface)this.processSystem.getUnit(names.get(i))).getMechanicalDesign().getCostEstimate().getTotaltCost();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cost;
    }

    public int hashCode() {
        return Objects.hash(this.CAPEXperWeight);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CostEstimateBaseClass other = (CostEstimateBaseClass)obj;
        return Double.doubleToLongBits(this.CAPEXperWeight) == Double.doubleToLongBits(other.CAPEXperWeight);
    }
}

