/*
 * Decompiled with CFR 0.152.
 */
package neqsim.processSimulation.controllerDevice;

import neqsim.processSimulation.controllerDevice.ControllerDeviceInterface;
import neqsim.processSimulation.measurementDevice.MeasurementDeviceInterface;
import neqsim.util.NamedBaseClass;

public class ControllerDeviceBaseClass
extends NamedBaseClass
implements ControllerDeviceInterface {
    private static final long serialVersionUID = 1000L;
    private String unit = "[?]";
    private MeasurementDeviceInterface transmitter = null;
    private double controllerSetPoint = 0.0;
    private double oldError = 0.0;
    private double oldoldError = 0.0;
    private double error = 0.0;
    private double response = 30.0;
    int propConstant = 1;
    private boolean reverseActing = false;
    private double Ksp = 1.0;
    private double Tint = 300.0;
    private double TintValue = 0.0;
    private double Tderiv = 300.0;

    public ControllerDeviceBaseClass() {
        super("controller");
    }

    @Override
    public void setTransmitter(MeasurementDeviceInterface device) {
        this.transmitter = device;
    }

    @Override
    public double getMeasuredValue() {
        return this.transmitter.getMeasuredValue();
    }

    @Override
    public void runTransient(double percentSignal, double dt) {
        if (this.isReverseActing()) {
            this.propConstant = -1;
        }
        this.oldoldError = this.error;
        this.oldError = this.error;
        this.error = this.transmitter.getMeasuredPercentValue() - (this.controllerSetPoint - this.transmitter.getMinimumValue()) / (this.transmitter.getMaximumValue() - this.transmitter.getMinimumValue()) * 100.0;
        this.TintValue += this.Ksp / this.Tint * this.error * dt;
        double TderivValue = this.Ksp * this.Tderiv * (this.error - this.oldError) / dt;
        this.response = percentSignal + (double)this.propConstant * (this.Ksp * this.error + this.TintValue + TderivValue);
    }

    @Override
    public void setControllerSetPoint(double signal) {
        this.controllerSetPoint = signal;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUnit(String unit) {
        this.unit = unit;
    }

    @Override
    public double getResponse() {
        return this.response;
    }

    @Override
    public boolean isReverseActing() {
        return this.reverseActing;
    }

    @Override
    public void setReverseActing(boolean reverseActing) {
        this.reverseActing = reverseActing;
    }

    public double getKsp() {
        return this.Ksp;
    }

    public void setKsp(double Ksp) {
        this.Ksp = Ksp;
    }

    @Override
    public void setControllerParameters(double Ksp, double Ti, double Td) {
        this.setKsp(Ksp);
        this.setTint(Ti);
        this.setTderiv(Td);
    }

    public double getTint() {
        return this.Tint;
    }

    public void setTint(double Tint) {
        this.Tint = Tint;
    }

    public double getTderiv() {
        return this.Tderiv;
    }

    public void setTderiv(double Tderiv) {
        this.Tderiv = Tderiv;
    }
}

