/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompConductivity.linearLiquidModel;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.physicalProperties.util.parameterFitting.pureComponentParameterFitting.pureCompConductivity.linearLiquidModel.ConductivityFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestConductivityFit {
    static Logger logger = LogManager.getLogger(TestConductivityFit.class);

    public static void main(String[] args) {
        LevenbergMarquardt optim = new LevenbergMarquardt();
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentconductivitydata WHERE ComponentName='TEG'");
        try {
            logger.info("adding....");
            while (dataSet.next()) {
                ConductivityFunction function = new ConductivityFunction();
                double[] guess = new double[]{-0.384, 0.00525, -6.37E-6};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 1.1);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                testSystem.setPressure(Double.parseDouble(dataSet.getString("Pressure")));
                testSystem.init(0);
                testSystem.createDatabase(true);
                testSystem.setMixingRule(2);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double[] standardDeviation1 = new double[]{0.1};
                SampleValue sample = new SampleValue(Double.parseDouble(dataSet.getString("Conductivity")), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                sample.setThermodynamicSystem(testSystem);
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            logger.error("database error" + e);
        }
        double[] sample1 = new double[]{0.1};
        for (int i = 0; i < sampleList.size(); ++i) {
            logger.info("ans: " + sampleList.get(i).getFunction().calcValue(sample1));
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        optim.setSampleSet(sampleSet);
        optim.solve();
        optim.displayResult();
        optim.displayCurveFit();
    }
}

