/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.viscosity;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.viscosity.Viscosity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;

public class AmineViscosity
extends Viscosity {
    private static final long serialVersionUID = 1000L;

    public AmineViscosity() {
    }

    public AmineViscosity(PhysicalPropertiesInterface liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public double calcViscosity() {
        super.calcViscosity();
        double wtFracA = this.liquidPhase.getPhase().getComponent("MDEA").getx() * this.liquidPhase.getPhase().getComponent("MDEA").getMolarMass() / this.liquidPhase.getPhase().getMolarMass();
        double viscA = -12.197 - 8.905 * (wtFracA += this.liquidPhase.getPhase().getComponent("MDEA+").getx() * this.liquidPhase.getPhase().getComponent("MDEA+").getMolarMass() / this.liquidPhase.getPhase().getMolarMass());
        double viscB = 1438.717 + 4218.749 * wtFracA;
        double logviscosity = viscA + viscB / this.liquidPhase.getPhase().getTemperature();
        return Math.exp(logviscosity);
    }
}

