/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.liquidPhysicalProperties.diffusivity.SiddiqiLucasMethod;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AmineDiffusivity
extends SiddiqiLucasMethod {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(AmineDiffusivity.class);

    public AmineDiffusivity() {
    }

    public AmineDiffusivity(PhysicalPropertiesInterface liquidPhase) {
        super(liquidPhase);
    }

    @Override
    public void calcEffectiveDiffusionCoefficients() {
        super.calcEffectiveDiffusionCoefficients();
        double co2waterdiff = 0.03389 * Math.exp(-2213.7 / this.liquidPhase.getPhase().getTemperature()) * 1.0E-4;
        double n2owaterdiff = 0.03168 * Math.exp(-2209.4 / this.liquidPhase.getPhase().getTemperature()) * 1.0E-4;
        double n2oaminediff = 5.533E-8 * this.liquidPhase.getPhase().getTemperature() / Math.pow(this.liquidPhase.getViscosity(), 0.545) * 1.0E-4;
        try {
            double molConsMDEA = this.liquidPhase.getPhase().getComponent("MDEA").getx() * this.liquidPhase.getPhase().getDensity() / this.liquidPhase.getPhase().getMolarMass();
            this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent((String)"CO2").getComponentNumber()] = n2oaminediff * co2waterdiff / n2owaterdiff;
            this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent((String)"MDEA").getComponentNumber()] = 0.0207 * Math.exp(-2360.7 / this.liquidPhase.getPhase().getTemperature() - 2.4727E-4 * (molConsMDEA += this.liquidPhase.getPhase().getComponent("MDEA+").getx() * this.liquidPhase.getPhase().getDensity() / this.liquidPhase.getPhase().getMolarMass())) * 1.0E-4;
        }
        catch (Exception e) {
            logger.error("error eff diff calc " + e.toString());
        }
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        this.calcEffectiveDiffusionCoefficients();
        if (this.liquidPhase.getPhase().getComponent(i).getComponentName().equals("MDEA")) {
            return this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent("MDEA").getComponentNumber()];
        }
        return this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent("CO2").getComponentNumber()];
    }

    @Override
    public double[][] calcDiffusionCoefficients(int binaryDiffusionCoefficientMethod, int multicomponentDiffusionMethod) {
        this.calcEffectiveDiffusionCoefficients();
        for (int i = 0; i < this.liquidPhase.getPhase().getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.liquidPhase.getPhase().getNumberOfComponents(); ++j) {
                this.binaryDiffusionCoefficients[i][j] = this.liquidPhase.getPhase().getComponent(i).getComponentName().equals("MDEA") ? this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent("MDEA").getComponentNumber()] : this.effectiveDiffusionCoefficient[this.liquidPhase.getPhase().getComponent("CO2").getComponentNumber()];
            }
        }
        return this.binaryDiffusionCoefficients;
    }
}

