/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.gasPhysicalProperties.diffusivity.Diffusivity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;

public class WilkeLeeDiffusivity
extends Diffusivity {
    private static final long serialVersionUID = 1000L;
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;

    public WilkeLeeDiffusivity() {
    }

    public WilkeLeeDiffusivity(PhysicalPropertiesInterface gasPhase) {
        super(gasPhase);
        this.binaryDiffusionCoefficients = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
        this.binaryLennardJonesOmega = new double[gasPhase.getPhase().getNumberOfComponents()][gasPhase.getPhase().getNumberOfComponents()];
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        double A2 = 1.06036;
        double B2 = 0.1561;
        double C2 = 0.193;
        double D2 = 0.47635;
        double E2 = 1.03587;
        double F2 = 1.52996;
        double G2 = 1.76474;
        double H2 = 3.89411;
        double tempVar2 = this.gasPhase.getPhase().getTemperature() / this.binaryEnergyParameter[i][j];
        this.binaryLennardJonesOmega[i][j] = A2 / Math.pow(tempVar2, B2) + C2 / Math.exp(D2 * tempVar2) + E2 / Math.exp(F2 * tempVar2) + G2 / Math.exp(H2 * tempVar2);
        this.binaryDiffusionCoefficients[i][j] = (3.03 - 0.98 / Math.sqrt(this.binaryMolecularMass[i][j]) * 0.001 * Math.pow(this.gasPhase.getPhase().getTemperature(), 1.5)) / (this.gasPhase.getPhase().getPressure() * Math.sqrt(this.binaryMolecularMass[i][j]) * Math.pow(this.binaryMolecularDiameter[i][j], 2.0) * this.binaryLennardJonesOmega[i][j]);
        return this.binaryDiffusionCoefficients[i][j] * 1.0E-4;
    }
}

