/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.diffusivity;

import neqsim.physicalProperties.physicalPropertyMethods.commonPhasePhysicalProperties.diffusivity.Diffusivity;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;

public class CorrespondingStatesDiffusivity
extends Diffusivity {
    private static final long serialVersionUID = 1000L;
    double[][] binaryDiffusionCoefficients;
    double[][] binaryLennardJonesOmega;

    public CorrespondingStatesDiffusivity() {
    }

    public CorrespondingStatesDiffusivity(PhysicalPropertiesInterface phase) {
        super(phase);
        this.binaryDiffusionCoefficients = new double[phase.getPhase().getNumberOfComponents()][phase.getPhase().getNumberOfComponents()];
    }

    @Override
    public double calcBinaryDiffusionCoefficient(int i, int j, int method) {
        if (this.phase.getPhase().getPhaseType() == 0) {
            this.binaryDiffusionCoefficients[i][j] = 9.890000000000001E-12 * Math.pow(this.phase.getViscosity() * 1000.0, -0.907) * Math.pow(1.0 / this.phase.getPhase().getComponents()[i].getNormalLiquidDensity() * this.phase.getPhase().getComponents()[i].getMolarMass() * 1000.0, -0.45) * Math.pow(1.0 / this.phase.getPhase().getComponents()[j].getNormalLiquidDensity() * this.phase.getPhase().getComponents()[j].getMolarMass() * 1000.0, 0.265) * this.phase.getPhase().getTemperature();
            return this.binaryDiffusionCoefficients[i][j];
        }
        this.binaryDiffusionCoefficients[i][j] = 1.8E-5 / this.phase.getPhase().getPressure();
        return this.binaryDiffusionCoefficients[i][j];
    }
}

