/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties.interfaceProperties.surfaceTension;

import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemInterface;

public class GTSurfaceTensionUtils {
    private static final double Pa = 1.0E-5;
    private static final double m3 = 1.0E-5;

    public static void mufun(SystemInterface sys, int ncomp, double t, double[] rho, double[] mu, double[][] dmu_drho, double[] p) {
        int i;
        double v = 1.0;
        double[] nv = new double[ncomp];
        PhaseInterface phase = sys.getPhase(0);
        sys.setTemperature(t);
        phase.setTotalVolume(v);
        for (i = 0; i < ncomp; ++i) {
            double n;
            if (rho[i] < 0.0) {
                throw new RuntimeException("Number density is negative.");
            }
            nv[i] = n = rho[i] * 1.0E-5;
        }
        sys.setMolarFlowRates(nv);
        sys.init_x_y();
        sys.setBeta(1.0);
        sys.init(3);
        for (i = 0; i < ncomp; ++i) {
            mu[i] = sys.getPhase(0).getComponent(i).getChemicalPotential(sys.getPhase(0));
            if (Double.isNaN(mu[i])) {
                throw new RuntimeException("Thermo returned NaN for chemical potential.");
            }
            for (int j = 0; j < ncomp; ++j) {
                dmu_drho[i][j] = sys.getPhase(0).getComponent(i).getChemicalPotentialdNTV(j, sys.getPhase(0)) * 1.0E-5;
            }
        }
        p[0] = sys.getPhase(0).getPressure() / 1.0E-5;
    }

    private GTSurfaceTensionUtils() {
    }
}

