/*
 * Decompiled with CFR 0.152.
 */
package neqsim.physicalProperties;

import java.io.Serializable;
import neqsim.physicalProperties.mixingRule.PhysicalPropertyMixingRule;
import neqsim.physicalProperties.physicalPropertySystem.PhysicalPropertiesInterface;
import neqsim.physicalProperties.physicalPropertySystem.commonPhasePhysicalProperties.DefaultPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.gasPhysicalProperties.GasPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.liquidPhysicalProperties.AminePhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.liquidPhysicalProperties.CO2waterPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.liquidPhysicalProperties.GlycolPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.liquidPhysicalProperties.LiquidPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.liquidPhysicalProperties.WaterPhysicalProperties;
import neqsim.physicalProperties.physicalPropertySystem.solidPhysicalProperties.SolidPhysicalProperties;
import neqsim.thermo.phase.PhaseInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PhysicalPropertyHandler
implements Cloneable,
Serializable {
    private PhysicalPropertiesInterface gasPhysicalProperties = null;
    private PhysicalPropertiesInterface oilPhysicalProperties = null;
    private PhysicalPropertiesInterface aqueousPhysicalProperties = null;
    private PhysicalPropertiesInterface solidPhysicalProperties = null;
    private PhysicalPropertyMixingRule mixingRule = null;
    static Logger logger = LogManager.getLogger(PhysicalPropertyHandler.class);
    private static final long serialVersionUID = 1000L;

    public void setPhysicalProperties(PhaseInterface phase, int type) {
        switch (type) {
            case 0: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new WaterPhysicalProperties(phase, 0, 0);
                break;
            }
            case 1: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new WaterPhysicalProperties(phase, 0, 0);
                break;
            }
            case 2: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new GlycolPhysicalProperties(phase, 0, 0);
                break;
            }
            case 3: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new AminePhysicalProperties(phase, 0, 0);
                break;
            }
            case 4: {
                this.gasPhysicalProperties = new GasPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new LiquidPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new CO2waterPhysicalProperties(phase, 0, 0);
                break;
            }
            case 6: {
                this.gasPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                this.oilPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                this.aqueousPhysicalProperties = new DefaultPhysicalProperties(phase, 0, 0);
                break;
            }
            default: {
                logger.error("error selecting physical properties model.\n Continue using default model...");
                this.setPhysicalProperties(phase, 0);
            }
        }
        this.solidPhysicalProperties = new SolidPhysicalProperties(phase);
        this.mixingRule = new PhysicalPropertyMixingRule();
        this.mixingRule.initMixingRules(phase);
        this.gasPhysicalProperties.setMixingRule(this.mixingRule);
        this.oilPhysicalProperties.setMixingRule(this.mixingRule);
        this.aqueousPhysicalProperties.setMixingRule(this.mixingRule);
    }

    public PhysicalPropertiesInterface getPhysicalProperty(PhaseInterface phase) {
        switch (phase.getPhaseTypeName()) {
            case "gas": {
                return this.gasPhysicalProperties;
            }
            case "oil": {
                return this.oilPhysicalProperties;
            }
            case "aqueous": {
                return this.aqueousPhysicalProperties;
            }
            case "solid": {
                return this.solidPhysicalProperties;
            }
            case "wax": {
                return this.solidPhysicalProperties;
            }
            case "hydrate": {
                return this.solidPhysicalProperties;
            }
        }
        return this.gasPhysicalProperties;
    }

    public PhysicalPropertyHandler clone() {
        PhysicalPropertyHandler clonedHandler = null;
        try {
            clonedHandler = (PhysicalPropertyHandler)super.clone();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        try {
            if (this.gasPhysicalProperties != null) {
                clonedHandler.gasPhysicalProperties = this.gasPhysicalProperties.clone();
            }
            if (this.oilPhysicalProperties != null) {
                clonedHandler.oilPhysicalProperties = this.oilPhysicalProperties.clone();
            }
            if (this.aqueousPhysicalProperties != null) {
                clonedHandler.aqueousPhysicalProperties = this.aqueousPhysicalProperties.clone();
            }
            if (this.solidPhysicalProperties != null) {
                clonedHandler.solidPhysicalProperties = this.solidPhysicalProperties.clone();
            }
            if (this.mixingRule != null) {
                clonedHandler.mixingRule = this.mixingRule.clone();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedHandler;
    }
}

