/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.parameterFitting.masstransfer;

import java.sql.ResultSet;
import java.util.ArrayList;
import neqsim.fluidMechanics.util.parameterFitting.masstransfer.MassTransferFunction;
import neqsim.statistics.parameterFitting.SampleSet;
import neqsim.statistics.parameterFitting.SampleValue;
import neqsim.statistics.parameterFitting.nonLinearParameterFitting.LevenbergMarquardt;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.util.database.NeqSimDataBase;

public class TestMassTransfer {
    public static void main(String[] args) {
        ArrayList<SampleValue> sampleList = new ArrayList<SampleValue>();
        NeqSimDataBase database = new NeqSimDataBase();
        ResultSet dataSet = database.getResultSet("SELECT * FROM purecomponentvapourpressures WHERE ComponentName='water' AND VapourPressure<100");
        try {
            System.out.println("adding....");
            while (dataSet.next()) {
                MassTransferFunction function = new MassTransferFunction();
                double[] guess = new double[]{0.3311};
                double[][] bound = new double[][]{{0.0, 1.0}};
                function.setInitialGuess(guess);
                SystemSrkEos testSystem = new SystemSrkEos(280.0, 0.001);
                testSystem.addComponent(dataSet.getString("ComponentName"), 100.0);
                double[] sample1 = new double[]{Double.parseDouble(dataSet.getString("Temperature"))};
                double vappres = Double.parseDouble(dataSet.getString("VapourPressure"));
                double[] standardDeviation1 = new double[]{0.15};
                SampleValue sample = new SampleValue(Math.log(vappres), Double.parseDouble(dataSet.getString("StandardDeviation")), sample1, standardDeviation1);
                sample.setFunction(function);
                function.setInitialGuess(guess);
                sample.setThermodynamicSystem(testSystem);
                sample.setReference(dataSet.getString("Reference"));
                sampleList.add(sample);
            }
        }
        catch (Exception e) {
            System.out.println("database error" + e);
        }
        SampleSet sampleSet = new SampleSet(sampleList);
        LevenbergMarquardt optim = new LevenbergMarquardt();
        optim.setSampleSet(sampleSet);
        optim.solve();
    }
}

