/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.twoPhasePipeFlowVisualization;

import neqsim.dataPresentation.fileHandeling.createNetCDF.netCDF2D.NetCdf2D;
import neqsim.dataPresentation.visAD.visAdInterface;
import neqsim.fluidMechanics.flowSystem.FlowSystem;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.twoPhaseFlowNodeVisualization.TwoPhaseFlowNodeVisualization;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.twoPhaseFlowVisualization.TwoPhaseFlowVisualization;

public class TwoPhasePipeFlowVisualization
extends TwoPhaseFlowVisualization {
    double[][][] pressurePoint = new double[2][10][10];
    double[][][] velocityPoint = new double[2][10][10];
    double[][][] reynoldsNumber = new double[2][10][10];
    double[][][] phaseFraction = new double[2][10][10];
    double[][][] temperaturePoint = new double[2][10][10];
    double[][][] interphaseContactLength = new double[2][10][10];
    double[][][] interfaceTemperaturePoint = new double[2][10][10];
    public double[][][][] bulkComposition;
    public double[][][][] interfaceComposition;
    public double[][][][] effectiveMassTransferCoefficient;
    public double[][][][] molarFlux;
    public double[][][][] schmidtNumber;
    public double[][][][] totalMolarMassTransferRate;
    public double[][][][] totalVolumetricMassTransferRate;
    double[] xPlace = new double[10];
    double[] timeArray = new double[10];
    visAdInterface plot;

    public TwoPhasePipeFlowVisualization() {
    }

    public TwoPhasePipeFlowVisualization(int nodes, int timeSteps) {
        this.flowNodes = new TwoPhaseFlowNodeVisualization[timeSteps][nodes];
        this.flowSystem = new FlowSystem[timeSteps];
        this.absTime = new double[timeSteps];
        for (int i = 0; i < timeSteps; ++i) {
            for (int j = 0; j < nodes; ++j) {
                this.flowNodes[i][j] = new TwoPhaseFlowNodeVisualization();
            }
        }
    }

    @Override
    public void setPoints() {
        this.pressurePoint = new double[2][this.time][this.flowNodes[0].length];
        this.temperaturePoint = new double[2][this.time][this.flowNodes[0].length];
        this.interphaseContactLength = new double[2][this.time][this.flowNodes[0].length];
        this.velocityPoint = new double[2][this.time][this.flowNodes[0].length];
        this.reynoldsNumber = new double[2][this.time][this.flowNodes[0].length];
        this.phaseFraction = new double[2][this.time][this.flowNodes[0].length];
        this.interfaceTemperaturePoint = new double[2][this.time][this.flowNodes[0].length];
        this.bulkComposition = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.effectiveMassTransferCoefficient = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.interfaceComposition = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.molarFlux = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.schmidtNumber = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.totalMolarMassTransferRate = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.totalVolumetricMassTransferRate = new double[2][this.flowNodes[0][0].getNumberOfComponents()][this.time][this.flowNodes[0].length];
        this.xPlace = new double[this.flowNodes[0].length];
        this.timeArray = new double[this.time];
        for (int k = 0; k < 2; ++k) {
            for (int j = 0; j < this.time; ++j) {
                this.timeArray[j] = j;
                for (int i = 0; i < this.flowNodes[j].length; ++i) {
                    this.xPlace[i] = this.flowNodes[j][i].getDistanceToCenterOfNode();
                    this.pressurePoint[k][j][i] = this.flowNodes[j][i].getPressure(k);
                    this.interphaseContactLength[k][j][i] = this.flowNodes[j][i].getInterphaseContactLength();
                    this.temperaturePoint[k][j][i] = this.flowNodes[j][i].getTemperature(k);
                    this.velocityPoint[k][j][i] = this.flowNodes[j][i].getVelocity(k);
                    this.reynoldsNumber[k][j][i] = this.flowNodes[j][i].getReynoldsNumber(k);
                    this.phaseFraction[k][j][i] = this.flowNodes[j][i].getPhaseFraction(k);
                    this.interfaceTemperaturePoint[k][j][i] = this.flowNodes[j][i].getInterfaceTemperature(k);
                    for (int p = 0; p < this.flowNodes[0][0].getNumberOfComponents(); ++p) {
                        this.effectiveMassTransferCoefficient[k][p][j][i] = this.flowNodes[j][i].getEffectiveMassTransferCoefficient(p, k);
                        this.bulkComposition[k][p][j][i] = this.flowNodes[j][i].getBulkComposition(p, k);
                        this.interfaceComposition[k][p][j][i] = this.flowNodes[j][i].getInterfaceComposition(p, k);
                        this.molarFlux[k][p][j][i] = this.flowNodes[j][i].getEffectiveSchmidtNumber(p, k);
                        this.schmidtNumber[k][p][j][i] = this.flowNodes[j][i].getEffectiveSchmidtNumber(p, k);
                        this.totalMolarMassTransferRate[k][p][j][i] = this.flowSystem[j].getTotalMolarMassTransferRate(p, i);
                        this.totalVolumetricMassTransferRate[k][p][j][i] = this.totalMolarMassTransferRate[k][p][j][i] * 60.0 / 40.87631889 * 1000.0;
                    }
                }
            }
        }
    }

    @Override
    public void displayResult(String name) {
        this.setPoints();
    }

    @Override
    public void createNetCdfFile(String name) {
        this.setPoints();
        NetCdf2D file = new NetCdf2D();
        file.setOutputFileName(name);
        file.setXvalues(this.xPlace, "length", "meter");
        file.setYvalues(this.pressurePoint[0][0], "gas pressure", "sec");
        file.setYvalues(this.pressurePoint[1][0], "liquid pressure", "sec");
        file.setYvalues(this.velocityPoint[0][0], "gas velocity", "sec");
        file.setYvalues(this.velocityPoint[1][0], "liquid velocity", "sec");
        file.setYvalues(this.reynoldsNumber[0][0], "gas reynolds number", "sec");
        file.setYvalues(this.reynoldsNumber[1][0], "liquid reynolds number", "sec");
        file.setYvalues(this.temperaturePoint[0][0], "gas temperature", "sec");
        file.setYvalues(this.temperaturePoint[1][0], "liquid temperature", "sec");
        file.setYvalues(this.phaseFraction[0][0], "void fraction", "sec");
        file.setYvalues(this.phaseFraction[1][0], "holdup", "sec");
        file.setYvalues(this.interfaceTemperaturePoint[0][0], "gas interface temperature", "sec");
        file.setYvalues(this.interfaceTemperaturePoint[1][0], "liquid interface temperature", "sec");
        file.setYvalues(this.interphaseContactLength[0][0], "interphase contact length", "sec");
        for (int p = 0; p < this.flowNodes[0][0].getNumberOfComponents(); ++p) {
            String comp = "component molefraction " + p;
            file.setYvalues(this.bulkComposition[0][p][0], "gas " + comp + p, "sec");
            file.setYvalues(this.bulkComposition[1][p][0], "liquid " + comp + p, "sec");
            file.setYvalues(this.interfaceComposition[0][p][0], "gas (interphase) " + comp, "sec");
            file.setYvalues(this.interfaceComposition[1][p][0], "liquid (interphase) " + comp, "sec");
            file.setYvalues(this.molarFlux[0][p][0], "gas molar flux " + comp + p, "sec");
            file.setYvalues(this.molarFlux[1][p][0], "liquid molar flux " + comp + p, "sec");
            file.setYvalues(this.totalVolumetricMassTransferRate[0][p][0], "total gas Volumetric Mass Transfer " + comp + p, "sec");
            file.setYvalues(this.totalVolumetricMassTransferRate[1][p][0], "total liq Volumetric Mass Transfer " + comp + p, "sec");
            file.setYvalues(this.effectiveMassTransferCoefficient[0][p][0], "eff. masstransfer coef gas " + comp + p, "sec");
            file.setYvalues(this.effectiveMassTransferCoefficient[1][p][0], "eff. masstransfer coef liq " + comp + p, "sec");
            file.setYvalues(this.schmidtNumber[0][p][0], "gas scmidtnumber " + comp + p, "-");
            file.setYvalues(this.schmidtNumber[1][p][0], "liquid scmidtnumber " + comp + p, "-");
        }
        file.createFile();
    }
}

