/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization;

import neqsim.fluidMechanics.flowSystem.FlowSystemInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.FlowNodeVisualization;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowNodeVisualization.FlowNodeVisualizationInterface;
import neqsim.fluidMechanics.util.fluidMechanicsVisualization.flowSystemVisualization.FlowSystemVisualizationInterface;

public class FlowSystemVisualization
implements FlowSystemVisualizationInterface {
    protected FlowNodeVisualizationInterface[][] flowNodes;
    protected FlowSystemInterface[] flowSystem;
    protected int time = 0;
    protected double[] absTime;

    public FlowSystemVisualization() {
    }

    public FlowSystemVisualization(int nodes, int timeSteps) {
        this.flowNodes = new FlowNodeVisualization[timeSteps][nodes];
        this.flowSystem = new FlowSystemInterface[timeSteps];
        this.absTime = new double[timeSteps];
        for (int i = 0; i < timeSteps; ++i) {
            for (int j = 0; j < nodes; ++j) {
                this.flowNodes[i][j] = new FlowNodeVisualization();
            }
        }
    }

    @Override
    public void setNextData(FlowSystemInterface system) {
        this.flowSystem[this.time] = system;
        this.absTime[this.time] = 0.0;
        for (int i = 0; i < this.flowNodes[this.time].length; ++i) {
            this.flowNodes[this.time][i].setData(system.getNode(i));
        }
        ++this.time;
    }

    @Override
    public void setNextData(FlowSystemInterface system, double abstime) {
        this.flowSystem[this.time] = system;
        this.absTime[this.time] = abstime;
        for (int i = 0; i < this.flowNodes[this.time].length; ++i) {
            this.flowNodes[this.time][i].setData(system.getNode(i));
        }
        ++this.time;
    }

    @Override
    public void createNetCdfFile(String name) {
        System.out.println("ok...");
        for (int j = 0; j < this.time; ++j) {
            for (int i = 0; i < this.flowNodes[j].length; ++i) {
                System.out.println("time " + this.time + " pres " + this.flowNodes[j][i].getPressure(0));
            }
        }
    }

    @Override
    public void setPoints() {
    }

    @Override
    public void displayResult(String name) {
    }
}

