/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.geometryDefinitions;

import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.packings.PackingInterface;
import neqsim.fluidMechanics.geometryDefinitions.internalGeometry.wall.Wall;
import neqsim.fluidMechanics.geometryDefinitions.surrounding.SurroundingEnvironment;
import neqsim.fluidMechanics.geometryDefinitions.surrounding.SurroundingEnvironmentBaseClass;
import neqsim.thermo.ThermodynamicConstantsInterface;

public abstract class GeometryDefinition
implements GeometryDefinitionInterface,
ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    double wallHeatTransferCoefficient = 20.0;
    private double innerWallTemperature = 276.5;
    protected PackingInterface packing = null;
    public double diameter = 0.0;
    public double radius = 0.0;
    public double innerSurfaceRoughness = 5.0E-6;
    public double nodeLength = 0.0;
    public double area = 0.0;
    public double relativeRoughnes = 0.0;
    public double[] layerConductivity;
    public double[] layerThickness;
    public Wall wall = new Wall();
    private SurroundingEnvironment surroundingEnvironment = new SurroundingEnvironmentBaseClass();

    @Override
    public SurroundingEnvironment getSurroundingEnvironment() {
        return this.surroundingEnvironment;
    }

    @Override
    public void setSurroundingEnvironment(SurroundingEnvironment surroundingEnvironment) {
        this.surroundingEnvironment = surroundingEnvironment;
    }

    public Wall getWall() {
        return this.wall;
    }

    public void setWall(Wall wall) {
        this.wall = wall;
    }

    public GeometryDefinition() {
    }

    public GeometryDefinition(double diameter) {
        this.diameter = diameter;
        this.radius = diameter / 2.0;
        this.area = 3.14159265 * Math.pow(this.radius, 2.0);
    }

    public GeometryDefinition(double diameter, double roughness) {
        this(diameter);
        this.relativeRoughnes = roughness / diameter;
        this.innerSurfaceRoughness = roughness;
    }

    @Override
    public GeometryDefinitionInterface clone() {
        GeometryDefinition clonedGeometry = null;
        try {
            clonedGeometry = (GeometryDefinition)super.clone();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return clonedGeometry;
    }

    @Override
    public void setNodeLength(double nodeLength) {
        this.nodeLength = nodeLength;
    }

    @Override
    public void setInnerSurfaceRoughness(double innerSurfaceRoughness) {
        this.innerSurfaceRoughness = innerSurfaceRoughness;
    }

    @Override
    public void init() {
        this.radius = this.diameter / 2.0;
        this.area = 3.14159265 * Math.pow(this.radius, 2.0);
        this.relativeRoughnes = this.innerSurfaceRoughness / this.diameter;
    }

    @Override
    public void setDiameter(double diameter) {
        this.diameter = diameter;
        this.radius = diameter / 2.0;
        this.area = 3.14159265 * Math.pow(this.radius, 2.0);
    }

    @Override
    public double getWallHeatTransferCoefficient() {
        return this.wall.getHeatTransferCoefficient();
    }

    @Override
    public double getDiameter() {
        return this.diameter;
    }

    @Override
    public double getArea() {
        return this.area;
    }

    @Override
    public double getRadius() {
        return this.radius;
    }

    @Override
    public double getInnerSurfaceRoughness() {
        return this.innerSurfaceRoughness;
    }

    @Override
    public double getRelativeRoughnes() {
        return this.relativeRoughnes;
    }

    @Override
    public double getRelativeRoughnes(double diameter) {
        return this.innerSurfaceRoughness / diameter;
    }

    @Override
    public double getCircumference() {
        return 6.2831853 * this.radius;
    }

    @Override
    public double getNodeLength() {
        return this.nodeLength;
    }

    @Override
    public GeometryDefinitionInterface getGeometry() {
        return this;
    }

    @Override
    public void setPackingType(int i) {
    }

    @Override
    public void setPackingType(String name, String material, int size) {
        System.out.println("error - packing set in Geometry definition class");
    }

    @Override
    public PackingInterface getPacking() {
        return this.packing;
    }

    @Override
    public double getInnerWallTemperature() {
        return this.innerWallTemperature;
    }

    @Override
    public void setInnerWallTemperature(double temperature) {
        this.innerWallTemperature = temperature;
    }

    @Override
    public void setWallHeatTransferCoefficient(double wallHeatTransferCoefficient) {
        this.wallHeatTransferCoefficient = wallHeatTransferCoefficient;
    }
}

