/*
 * Decompiled with CFR 0.152.
 */
package neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.twoPhasePipeFlowSystem;

import neqsim.fluidMechanics.flowSystem.twoPhaseFlowSystem.twoPhasePipeFlowSystem.TwoPhasePipeFlowSystem;
import neqsim.fluidMechanics.geometryDefinitions.GeometryDefinitionInterface;
import neqsim.fluidMechanics.geometryDefinitions.pipe.PipeData;
import neqsim.thermo.system.SystemFurstElectrolyteEos;
import neqsim.thermodynamicOperations.ThermodynamicOperations;

public class TwoPhasePipeFlowSystemReac
extends TwoPhasePipeFlowSystem {
    private static final long serialVersionUID = 1000L;

    public static void main(String[] args) {
        TwoPhasePipeFlowSystemReac pipe = new TwoPhasePipeFlowSystemReac();
        SystemFurstElectrolyteEos testSystem = new SystemFurstElectrolyteEos(295.3, 50.01325);
        testSystem.addComponent("methane", 50.11152187, "Nlitre/min", 0);
        testSystem.addComponent("CO2", 50.11152181, "Nlitre/min", 0);
        testSystem.addComponent("water", 0.5662204876, "kg/min", 1);
        testSystem.addComponent("MDEA", 0.5662204876, "kg/min", 1);
        testSystem.chemicalReactionInit();
        testSystem.createDatabase(true);
        testSystem.setMixingRule(4);
        testSystem.setPhysicalPropertyModel(3);
        testSystem.initPhysicalProperties();
        pipe.setInletThermoSystem(testSystem);
        pipe.setNumberOfLegs(3);
        pipe.setNumberOfNodesInLeg(10);
        double[] height = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] length = new double[]{0.0, 0.03, 0.07, 0.13, 2.5, 3.7};
        double[] outerTemperature = new double[]{278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 278.0, 275.0, 275.0, 275.0, 275.0};
        pipe.setLegHeights(height);
        pipe.setLegPositions(length);
        pipe.setLegOuterTemperatures(outerTemperature);
        GeometryDefinitionInterface[] pipeGemometry = new PipeData[5];
        double[] pipeDiameter = new double[]{0.025, 0.025, 0.025, 0.025, 0.025};
        for (int i = 0; i < pipeDiameter.length; ++i) {
            pipeGemometry[i] = new PipeData(pipeDiameter[i]);
        }
        pipe.setEquipmentGeometry(pipeGemometry);
        pipe.createSystem();
        pipe.setEquilibriumMassTransfer(false);
        pipe.setEquilibriumHeatTransfer(false);
        pipe.init();
        pipe.solveSteadyState(2);
        ThermodynamicOperations testOps = new ThermodynamicOperations(pipe.getNode(2).getBulkSystem());
        testOps.TPflash();
        pipe.getDisplay().createNetCdfFile("c:/temp5.nc");
    }
}

